/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.health.CompositeHealth;
import org.springframework.boot.actuate.health.ContributorRegistry;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.NamedContributors;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.actuate.health.SystemHealth;
import org.springframework.util.Assert;

abstract class HealthEndpointSupport<C, T> {
    private final ContributorRegistry<C> registry;
    private final HealthEndpointGroups groups;

    @Deprecated
    HealthEndpointSupport() {
        throw new IllegalStateException("Unable to create " + this.getClass() + " using deprecated constructor");
    }

    HealthEndpointSupport(ContributorRegistry<C> registry, HealthEndpointGroups groups) {
        Assert.notNull(registry, (String)"Registry must not be null");
        Assert.notNull((Object)groups, (String)"Groups must not be null");
        this.registry = registry;
        this.groups = groups;
    }

    HealthResult<T> getHealth(SecurityContext securityContext, boolean alwaysIncludeDetails, String ... path) {
        HealthEndpointGroup group;
        HealthEndpointGroup healthEndpointGroup = group = path.length > 0 ? this.groups.get(path[0]) : null;
        if (group != null) {
            return this.getHealth(group, securityContext, alwaysIncludeDetails, path, 1);
        }
        return this.getHealth(this.groups.getPrimary(), securityContext, alwaysIncludeDetails, path, 0);
    }

    private HealthResult<T> getHealth(HealthEndpointGroup group, SecurityContext securityContext, boolean alwaysIncludeDetails, String[] path, int pathOffset) {
        boolean isRoot;
        boolean includeDetails = alwaysIncludeDetails || group.includeDetails(securityContext);
        boolean isSystemHealth = group == this.groups.getPrimary() && pathOffset == 0;
        boolean bl = isRoot = path.length - pathOffset == 0;
        if (!includeDetails && !isRoot) {
            return null;
        }
        Object contributor = this.getContributor(path, pathOffset);
        T health = this.getContribution(group, contributor, includeDetails, isSystemHealth ? this.groups.getNames() : null);
        return health != null ? new HealthResult<T>(health, group) : null;
    }

    private Object getContributor(String[] path, int pathOffset) {
        ContributorRegistry<C> contributor = this.registry;
        while (pathOffset < path.length) {
            if (!(contributor instanceof NamedContributors)) {
                return null;
            }
            contributor = ((NamedContributors)contributor).getContributor(path[pathOffset]);
            ++pathOffset;
        }
        return contributor;
    }

    private T getContribution(HealthEndpointGroup group, Object contributor, boolean includeDetails, Set<String> groupNames) {
        if (contributor instanceof NamedContributors) {
            return this.getAggregateHealth(group, (NamedContributors)contributor, includeDetails, groupNames);
        }
        return contributor != null ? (T)this.getHealth(contributor, includeDetails) : null;
    }

    private T getAggregateHealth(HealthEndpointGroup group, NamedContributors<C> namedContributors, boolean includeDetails, Set<String> groupNames) {
        LinkedHashMap<String, T> contributions = new LinkedHashMap<String, T>();
        for (NamedContributor namedContributor : namedContributors) {
            String name = namedContributor.getName();
            if (!group.isMember(name)) continue;
            T contribution = this.getContribution(group, namedContributor.getContributor(), includeDetails, null);
            contributions.put(name, contribution);
        }
        if (contributions.isEmpty()) {
            return null;
        }
        return (T)this.aggregateContributions(contributions, group.getStatusAggregator(), includeDetails, groupNames);
    }

    protected abstract T getHealth(C var1, boolean var2);

    protected abstract T aggregateContributions(Map<String, T> var1, StatusAggregator var2, boolean var3, Set<String> var4);

    protected final CompositeHealth getCompositeHealth(Map<String, HealthComponent> components, StatusAggregator statusAggregator, boolean includeDetails, Set<String> groupNames) {
        Map<String, HealthComponent> includedComponents;
        Status status = statusAggregator.getAggregateStatus(components.values().stream().map(HealthComponent::getStatus).collect(Collectors.toSet()));
        Map<String, HealthComponent> map = includedComponents = includeDetails ? components : null;
        if (groupNames != null) {
            return new SystemHealth(status, includedComponents, groupNames);
        }
        return new CompositeHealth(status, includedComponents);
    }

    static class HealthResult<T> {
        private final T health;
        private final HealthEndpointGroup group;

        HealthResult(T health, HealthEndpointGroup group) {
            this.health = health;
            this.group = group;
        }

        T getHealth() {
            return this.health;
        }

        HealthEndpointGroup getGroup() {
            return this.group;
        }
    }
}

