/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.Tag;
import org.springframework.boot.actuate.metrics.http.Outcome;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;

public final class WebFluxTags {
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_ROOT = Tag.of((String)"uri", (String)"root");
    private static final Tag URI_UNKNOWN = Tag.of((String)"uri", (String)"UNKNOWN");
    private static final Tag EXCEPTION_NONE = Tag.of((String)"exception", (String)"None");

    private WebFluxTags() {
    }

    public static Tag method(ServerWebExchange exchange) {
        return Tag.of((String)"method", (String)exchange.getRequest().getMethodValue());
    }

    public static Tag status(ServerWebExchange exchange) {
        HttpStatus status = exchange.getResponse().getStatusCode();
        if (status == null) {
            status = HttpStatus.OK;
        }
        return Tag.of((String)"status", (String)String.valueOf(status.value()));
    }

    public static Tag uri(ServerWebExchange exchange) {
        String path;
        PathPattern pathPattern = (PathPattern)exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (pathPattern != null) {
            return Tag.of((String)"uri", (String)pathPattern.getPatternString());
        }
        HttpStatus status = exchange.getResponse().getStatusCode();
        if (status != null) {
            if (status.is3xxRedirection()) {
                return URI_REDIRECTION;
            }
            if (status == HttpStatus.NOT_FOUND) {
                return URI_NOT_FOUND;
            }
        }
        if ((path = WebFluxTags.getPathInfo(exchange)).isEmpty()) {
            return URI_ROOT;
        }
        return URI_UNKNOWN;
    }

    private static String getPathInfo(ServerWebExchange exchange) {
        String path = exchange.getRequest().getPath().value();
        String uri = StringUtils.hasText((String)path) ? path : "/";
        return uri.replaceAll("//+", "/").replaceAll("/$", "");
    }

    public static Tag exception(Throwable exception) {
        if (exception != null) {
            String simpleName = exception.getClass().getSimpleName();
            return Tag.of((String)"exception", (String)(StringUtils.hasText((String)simpleName) ? simpleName : exception.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    public static Tag outcome(ServerWebExchange exchange) {
        HttpStatus status = exchange.getResponse().getStatusCode();
        Outcome outcome = status != null ? Outcome.forStatus(status.value()) : Outcome.UNKNOWN;
        return outcome.asTag();
    }
}

