/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.ApiVersion;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.Contributor;
import org.springframework.boot.actuate.health.HealthDescriptor;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointSupport;
import org.springframework.boot.actuate.health.IndicatedHealthDescriptor;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.registry.HealthContributorRegistry;
import org.springframework.boot.health.registry.ReactiveHealthContributorRegistry;

@Endpoint(id="health")
public class HealthEndpoint
extends HealthEndpointSupport<Health, HealthDescriptor> {
    public static final EndpointId ID = EndpointId.of("health");

    public HealthEndpoint(HealthContributorRegistry registry, ReactiveHealthContributorRegistry fallbackRegistry, HealthEndpointGroups groups, Duration slowContributorLoggingThreshold) {
        super(Contributor.blocking(registry, fallbackRegistry), groups, slowContributorLoggingThreshold);
    }

    @ReadOperation
    public HealthDescriptor health() {
        HealthDescriptor health = this.health(ApiVersion.V3, EMPTY_PATH);
        return health != null ? health : IndicatedHealthDescriptor.UP;
    }

    @ReadOperation
    public HealthDescriptor healthForPath(String ... path) {
        return this.health(ApiVersion.V3, path);
    }

    private HealthDescriptor health(ApiVersion apiVersion, String ... path) {
        HealthEndpointSupport.Result result = this.getResult(apiVersion, null, SecurityContext.NONE, true, path);
        return result != null ? (HealthDescriptor)result.descriptor() : null;
    }

    @Override
    protected HealthDescriptor aggregateDescriptors(ApiVersion apiVersion, Map<String, HealthDescriptor> contributions, StatusAggregator statusAggregator, boolean showComponents, Set<String> groupNames) {
        return this.getCompositeDescriptor(apiVersion, contributions, statusAggregator, showComponents, groupNames);
    }
}

