/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.ClassUtils;

public enum EmbeddedDatabaseConnection {
    NONE(null, null, null),
    H2(EmbeddedDatabaseType.H2, "org.h2.Driver", "jdbc:h2:mem:testdb;DB_CLOSE_DELAY=-1"),
    DERBY(EmbeddedDatabaseType.DERBY, "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:memory:testdb;create=true"),
    HSQL(EmbeddedDatabaseType.HSQL, "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:testdb");

    private final EmbeddedDatabaseType type;
    private final String driverClass;
    private final String url;
    static EmbeddedDatabaseConnection override;

    private EmbeddedDatabaseConnection(EmbeddedDatabaseType type, String driverClass, String url) {
        this.type = type;
        this.driverClass = driverClass;
        this.url = url;
    }

    public String getDriverClassName() {
        return this.driverClass;
    }

    public EmbeddedDatabaseType getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public static EmbeddedDatabaseConnection get(ClassLoader classLoader) {
        if (override != null) {
            return override;
        }
        for (EmbeddedDatabaseConnection candidate : EmbeddedDatabaseConnection.values()) {
            if (candidate == NONE || !ClassUtils.isPresent((String)candidate.getDriverClassName(), (ClassLoader)classLoader)) continue;
            return candidate;
        }
        return NONE;
    }
}

