/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationErrorHandler;
import org.springframework.boot.autoconfigure.AutoConfigurationReport;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AutoConfigurationReportLoggingInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
SpringApplicationErrorHandler {
    private static final String LOGGER_BEAN = "autoConfigurationReportLogger";
    private AutoConfigurationReportLogger loggerBean;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.loggerBean = new AutoConfigurationReportLogger(applicationContext);
        applicationContext.getBeanFactory().registerSingleton(LOGGER_BEAN, (Object)this.loggerBean);
    }

    public void handleError(SpringApplication application, ConfigurableApplicationContext applicationContext, String[] args, Throwable exception) {
        if (this.loggerBean != null) {
            this.loggerBean.logAutoConfigurationReport(true);
        }
    }

    public static class AutoConfigurationReportLogger
    implements ApplicationListener<ContextRefreshedEvent> {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final ConfigurableApplicationContext applicationContext;
        private final AutoConfigurationReport report;

        public AutoConfigurationReportLogger(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            this.report = AutoConfigurationReport.get(this.applicationContext.getBeanFactory());
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            if (event.getApplicationContext() == this.applicationContext) {
                this.logAutoConfigurationReport();
            }
        }

        private void logAutoConfigurationReport() {
            this.logAutoConfigurationReport(!this.applicationContext.isActive());
        }

        void logAutoConfigurationReport(boolean isCrashReport) {
            if (this.report.getConditionAndOutcomesBySource().size() > 0) {
                if (isCrashReport && this.logger.isInfoEnabled()) {
                    this.logger.info((Object)this.getLogMessage(this.report.getConditionAndOutcomesBySource()));
                } else if (!isCrashReport && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)this.getLogMessage(this.report.getConditionAndOutcomesBySource()));
                }
            }
        }

        private StringBuilder getLogMessage(Map<String, AutoConfigurationReport.ConditionAndOutcomes> outcomes) {
            StringBuilder message = new StringBuilder();
            message.append("\n\n\n");
            message.append("=========================\n");
            message.append("AUTO-CONFIGURATION REPORT\n");
            message.append("=========================\n\n\n");
            message.append("Positive matches:\n");
            message.append("-----------------\n");
            for (Map.Entry<String, AutoConfigurationReport.ConditionAndOutcomes> entry : outcomes.entrySet()) {
                if (!entry.getValue().isFullMatch()) continue;
                this.addLogMessage(message, entry.getKey(), entry.getValue());
            }
            message.append("\n\n");
            message.append("Negative matches:\n");
            message.append("-----------------\n");
            for (Map.Entry<String, AutoConfigurationReport.ConditionAndOutcomes> entry : outcomes.entrySet()) {
                if (entry.getValue().isFullMatch()) continue;
                this.addLogMessage(message, entry.getKey(), entry.getValue());
            }
            message.append("\n\n");
            return message;
        }

        private void addLogMessage(StringBuilder message, String source, AutoConfigurationReport.ConditionAndOutcomes conditionAndOutcomes) {
            message.append("\n   " + ClassUtils.getShortName((String)source) + "\n");
            for (AutoConfigurationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                message.append("      - ");
                if (StringUtils.hasLength((String)conditionAndOutcome.getOutcome().getMessage())) {
                    message.append(conditionAndOutcome.getOutcome().getMessage());
                } else {
                    message.append(conditionAndOutcome.getOutcome().isMatch() ? "matched" : "did not match");
                }
                message.append(" (");
                message.append(ClassUtils.getShortName(conditionAndOutcome.getCondition().getClass()));
                message.append(")\n");
            }
        }
    }
}

