/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitConnectionFactoryProperties.class})
public class RabbitAutoConfiguration {
    @Autowired
    private ConnectionFactory connectionFactory;

    @Bean
    @ConditionalOnExpression(value="${spring.rabbitmq.dynamic:true}")
    @ConditionalOnMissingBean(value={AmqpAdmin.class})
    public AmqpAdmin amqpAdmin(CachingConnectionFactory connectionFactory) {
        return new RabbitAdmin((ConnectionFactory)connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={RabbitTemplate.class})
    public RabbitTemplate rabbitTemplate() {
        return new RabbitTemplate(this.connectionFactory);
    }

    @ConfigurationProperties(name="spring.rabbitmq")
    public static class RabbitConnectionFactoryProperties {
        private String host = "localhost";
        private int port = 5672;
        private String username;
        private String password;
        private String virtualHost;
        private boolean dynamic = true;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public void setDynamic(boolean dynamic) {
            this.dynamic = dynamic;
        }

        public String getVirtualHost() {
            return this.virtualHost;
        }

        public void setVirtualHost(String virtualHost) {
            while (virtualHost.startsWith("/") && virtualHost.length() > 0) {
                virtualHost = virtualHost.substring(1);
            }
            this.virtualHost = "/" + virtualHost;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    protected static class RabbitConnectionFactoryCreator {
        protected RabbitConnectionFactoryCreator() {
        }

        @Bean
        public ConnectionFactory rabbitConnectionFactory(RabbitConnectionFactoryProperties config) {
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory(config.getHost());
            connectionFactory.setPort(config.getPort());
            if (config.getUsername() != null) {
                connectionFactory.setUsername(config.getUsername());
            }
            if (config.getPassword() != null) {
                connectionFactory.setPassword(config.getPassword());
            }
            if (config.getVirtualHost() != null) {
                connectionFactory.setVirtualHost(config.getVirtualHost());
            }
            return connectionFactory;
        }
    }
}

