/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Arrays;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.servlet.DispatcherServlet;

@Order(value=-2147483648)
@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={EmbeddedServletContainerFactory.class})
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
public class DispatcherServletAutoConfiguration {
    public static final String DEFAULT_DISPATCHER_SERVLET_BEAN_NAME = "dispatcherServlet";

    @Bean(name={"dispatcherServlet"})
    @Conditional(value={DefaultDispatcherServletCondition.class})
    public DispatcherServlet dispatcherServlet() {
        return new DispatcherServlet();
    }

    private static class DefaultDispatcherServletCondition
    extends SpringBootCondition {
        private DefaultDispatcherServletCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            String[] beans = beanFactory.getBeanNamesForType(DispatcherServlet.class, false, false);
            if (beans.length == 0) {
                return ConditionOutcome.match("no DispatcherServlet found");
            }
            if (Arrays.asList(beans).contains(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME)) {
                return ConditionOutcome.noMatch("found DispatcherServlet named dispatcherServlet");
            }
            return ConditionOutcome.match("one or more DispatcherServlets found and none is named dispatcherServlet");
        }
    }
}

