/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.batch.JobExecutionEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@Component
public class JobLauncherCommandLineRunner
implements CommandLineRunner,
ApplicationEventPublisherAware {
    private static Log logger = LogFactory.getLog(JobLauncherCommandLineRunner.class);
    @Autowired(required=false)
    private final JobParametersConverter converter = new DefaultJobParametersConverter();
    @Autowired
    private JobLauncher jobLauncher;
    @Autowired(required=false)
    private JobRegistry jobRegistry;
    private String jobName;
    @Autowired(required=false)
    private final Collection<Job> jobs = Collections.emptySet();
    private ApplicationEventPublisher publisher;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void run(String ... args) throws JobExecutionException {
        logger.info((Object)("Running default command line with: " + Arrays.asList(args)));
        this.launchJobFromProperties(StringUtils.splitArrayElementsIntoProperties((String[])args, (String)"="));
    }

    protected void launchJobFromProperties(Properties properties) throws JobExecutionException {
        JobParameters jobParameters = this.converter.getJobParameters(properties);
        this.executeRegisteredJobs(jobParameters);
        this.executeLocalJobs(jobParameters);
    }

    private void executeRegisteredJobs(JobParameters jobParameters) throws JobExecutionException {
        if (this.jobRegistry != null && StringUtils.hasText((String)this.jobName)) {
            Job job = this.jobRegistry.getJob(this.jobName);
            JobExecution execution = this.jobLauncher.run(job, jobParameters);
            if (this.publisher != null) {
                this.publisher.publishEvent((ApplicationEvent)new JobExecutionEvent(execution));
            }
        }
    }

    private void executeLocalJobs(JobParameters jobParameters) throws JobExecutionException {
        for (Job job : this.jobs) {
            if (StringUtils.hasText((String)this.jobName) && !PatternMatchUtils.simpleMatch((String)this.jobName, (String)job.getName())) {
                logger.debug((Object)("Skipped job: " + job.getName()));
                continue;
            }
            JobExecution execution = this.jobLauncher.run(job, jobParameters);
            if (this.publisher == null) continue;
            this.publisher.publishEvent((ApplicationEvent)new JobExecutionEvent(execution));
        }
    }
}

