/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class})
@ConditionalOnWebApplication
@Order(value=0x7FFFFFFC)
public class AuthenticationManagerConfiguration
implements WebSecurityConfigurer<WebSecurity> {
    @Autowired
    private SecurityProperties security;
    @Autowired
    private List<SecurityPrequisite> dependencies;

    public void init(WebSecurity builder) throws Exception {
    }

    public void configure(WebSecurity builder) throws Exception {
    }

    @Autowired
    public void authentication(AuthenticationManagerBuilder builder) throws Exception {
        SecurityAutoConfiguration.authentication(builder, this.security);
    }
}

