/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.AuthenticationManagerConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.SpringBootWebSecurityConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.AbstractConfiguredSecurityBuilder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={AuthenticationManager.class})
@EnableConfigurationProperties
@Import(value={SpringBootWebSecurityConfiguration.class, AuthenticationManagerConfiguration.class})
public class SecurityAutoConfiguration {
    private static Log logger = LogFactory.getLog(SecurityAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public SecurityProperties securityProperties() {
        return new SecurityProperties();
    }

    @Bean
    @ConditionalOnBean(value={AuthenticationManagerBuilder.class})
    @ConditionalOnMissingBean
    public AuthenticationManager authenticationManager(AuthenticationManagerBuilder builder, ObjectPostProcessor<Object> processor) throws Exception {
        if (!SecurityAutoConfiguration.isBuilt(builder)) {
            SecurityAutoConfiguration.authentication(builder, this.securityProperties());
        } else if (builder.getOrBuild() == null) {
            builder = new AuthenticationManagerBuilder(processor);
            SecurityAutoConfiguration.authentication(builder, this.securityProperties());
        }
        return (AuthenticationManager)builder.getOrBuild();
    }

    public static void authentication(AuthenticationManagerBuilder builder, SecurityProperties security) throws Exception {
        if (SecurityAutoConfiguration.isBuilt(builder)) {
            return;
        }
        SecurityProperties.User user = security.getUser();
        if (user.isDefaultPassword()) {
            logger.info((Object)("\n\nUsing default password for application endpoints: " + user.getPassword() + "\n\n"));
        }
        LinkedHashSet<String> roles = new LinkedHashSet<String>(user.getRole());
        builder.inMemoryAuthentication().withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()]));
    }

    private static boolean isBuilt(AuthenticationManagerBuilder builder) {
        Method configurers = ReflectionUtils.findMethod(AbstractConfiguredSecurityBuilder.class, (String)"getConfigurers");
        Method unbuilt = ReflectionUtils.findMethod(AbstractConfiguredSecurityBuilder.class, (String)"isUnbuilt");
        ReflectionUtils.makeAccessible((Method)configurers);
        ReflectionUtils.makeAccessible((Method)unbuilt);
        return !((Collection)ReflectionUtils.invokeMethod((Method)configurers, (Object)builder)).isEmpty() || (Boolean)ReflectionUtils.invokeMethod((Method)unbuilt, (Object)builder) == false;
    }
}

