/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnWebApplication
public class ServerPropertiesAutoConfiguration
implements ApplicationContextAware,
EmbeddedServletContainerCustomizer {
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public ServerProperties serverProperties() {
        return new ServerProperties();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void customize(ConfigurableEmbeddedServletContainerFactory factory) {
        Object[] serverPropertiesBeans = this.applicationContext.getBeanNamesForType(ServerProperties.class);
        Assert.state((serverPropertiesBeans.length == 1 ? 1 : 0) != 0, (String)("Multiple ServerProperties beans registered " + StringUtils.arrayToCommaDelimitedString((Object[])serverPropertiesBeans)));
    }
}

