/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class})
@Order(value=0x7FFFFFFC)
public class AuthenticationManagerConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    private static Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);
    @Autowired
    private List<SecurityPrequisite> dependencies;
    @Autowired
    private ObjectPostProcessor<Object> objectPostProcessor;
    @Autowired
    private SecurityProperties security;

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        auth.apply((SecurityConfigurer)new BootDefaultingAuthenticationConfigurerAdapter());
    }

    private class BootDefaultingAuthenticationConfigurerAdapter
    extends GlobalAuthenticationConfigurerAdapter {
        private BootDefaultingAuthenticationConfigurerAdapter() {
        }

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            if (auth.isConfigured()) {
                return;
            }
            SecurityProperties.User user = AuthenticationManagerConfiguration.this.security.getUser();
            if (user.isDefaultPassword()) {
                logger.info((Object)("\n\nUsing default password for application endpoints: " + user.getPassword() + "\n\n"));
            }
            AuthenticationManagerBuilder defaultAuth = new AuthenticationManagerBuilder(AuthenticationManagerConfiguration.this.objectPostProcessor);
            LinkedHashSet<String> roles = new LinkedHashSet<String>(user.getRole());
            AuthenticationManager parent = (AuthenticationManager)((AuthenticationManagerBuilder)((InMemoryUserDetailsManagerConfigurer)defaultAuth.inMemoryAuthentication().withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()])).and()).and()).build();
            auth.parentAuthenticationManager(parent);
        }
    }
}

