/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnExpression(value="${flyway.enabled:true}")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class FlywayAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    public static class FlywayConfiguration {
        @Autowired
        private FlywayProperties properties = new FlywayProperties();
        @Autowired
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        @Autowired(required=false)
        private DataSource dataSource;
        @Autowired(required=false)
        @FlywayDataSource
        private DataSource flywayDataSource;

        @PostConstruct
        public void checkLocationExists() {
            if (this.properties.isCheckLocation()) {
                Assert.state((!this.properties.getLocations().isEmpty() ? 1 : 0) != 0, (String)"Migration script locations not configured");
                boolean exists = false;
                for (String location : this.properties.getLocations()) {
                    Resource resource = this.resourceLoader.getResource(location);
                    exists = !exists && resource.exists();
                }
                Assert.state((boolean)exists, (String)("Cannot find migrations location in: " + this.properties.getLocations() + " (please add migrations or check your Flyway configuration)"));
            }
        }

        @Bean(initMethod="migrate")
        @ConfigurationProperties(prefix="flyway")
        public Flyway flyway() {
            Flyway flyway = new Flyway();
            if (this.properties.isCreateDataSource()) {
                flyway.setDataSource(this.properties.getUrl(), this.properties.getUser(), this.properties.getPassword(), this.properties.getInitSqls().toArray(new String[0]));
            } else if (this.flywayDataSource != null) {
                flyway.setDataSource(this.flywayDataSource);
            } else {
                flyway.setDataSource(this.dataSource);
            }
            return flyway;
        }
    }
}

