/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.liquibase;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={SpringLiquibase.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnExpression(value="${liquibase.enabled:true}")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class LiquibaseAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @EnableConfigurationProperties(value={LiquibaseProperties.class})
    public static class LiquibaseConfiguration {
        @Autowired
        private LiquibaseProperties properties = new LiquibaseProperties();
        @Autowired
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        @Autowired
        private DataSource dataSource;

        @PostConstruct
        public void checkChangelogExists() {
            if (this.properties.isCheckChangeLogLocation()) {
                Resource resource = this.resourceLoader.getResource(this.properties.getChangeLog());
                Assert.state((boolean)resource.exists(), (String)("Cannot find changelog location: " + resource + " (please add changelog or check your Liquibase configuration)"));
            }
        }

        @Bean
        public SpringLiquibase liquibase() {
            SpringLiquibase liquibase = new SpringLiquibase();
            liquibase.setChangeLog(this.properties.getChangeLog());
            liquibase.setContexts(this.properties.getContexts());
            liquibase.setDataSource(this.dataSource);
            liquibase.setDefaultSchema(this.properties.getDefaultSchema());
            liquibase.setDropFirst(this.properties.isDropFirst());
            liquibase.setShouldRun(this.properties.isEnabled());
            return liquibase;
        }
    }
}

