/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import javax.management.MBeanServer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.jmx.config.EnableIntegrationMBeanExport;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.jmx.support.MBeanServerFactoryBean;

@Configuration
@ConditionalOnClass(value={EnableIntegration.class})
@AutoConfigureAfter(value={JmxAutoConfiguration.class})
public class IntegrationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MBeanServer.class})
    public MBeanServerFactoryBean mbeanServer() {
        MBeanServerFactoryBean factory = new MBeanServerFactoryBean();
        factory.setLocateExistingServerIfPossible(true);
        return factory;
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationMBeanExporter.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnExpression(value="${spring.jmx.enabled:true}")
    @EnableIntegrationMBeanExport(defaultDomain="${spring.jmx.default_domain:}", server="${spring.jmx.server:mbeanServer}")
    protected static class IntegrationJmxConfiguration {
        protected IntegrationJmxConfiguration() {
        }
    }

    @Configuration
    @EnableIntegration
    protected static class IntegrationConfiguration {
        protected IntegrationConfiguration() {
        }
    }
}

