/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class OnBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    public static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private static final String[] NO_BEANS = new String[0];

    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<String> matching;
        BeanSearchSpec spec;
        StringBuffer matchMessage = new StringBuffer();
        if (metadata.isAnnotated(ConditionalOnBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnBean.class);
            matching = this.getMatchingBeans(context, spec);
            if (matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnBean " + spec + " found no beans");
            }
            matchMessage.append("@ConditionalOnBean " + spec + " found the following " + matching);
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnMissingBean.class);
            matching = this.getMatchingBeans(context, spec);
            if (!matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnMissingBean " + spec + " found the following " + matching);
            }
            matchMessage.append(matchMessage.length() == 0 ? "" : " ");
            matchMessage.append("@ConditionalOnMissingBean " + spec + " found no beans");
        }
        return ConditionOutcome.match(matchMessage.toString());
    }

    private List<String> getMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.PARENTS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        if (beanFactory == null) {
            return Collections.emptyList();
        }
        ArrayList<String> beanNames = new ArrayList<String>();
        boolean considerHierarchy = beans.getStrategy() == SearchStrategy.ALL;
        for (String type : beans.getTypes()) {
            beanNames.addAll(this.getBeanNamesForType(beanFactory, type, context.getClassLoader(), considerHierarchy));
        }
        for (String annotation : beans.getAnnotations()) {
            beanNames.addAll(Arrays.asList(this.getBeanNamesForAnnotation(beanFactory, annotation, context.getClassLoader(), considerHierarchy)));
        }
        for (String beanName : beans.getNames()) {
            if (!this.containsBean(beanFactory, beanName, considerHierarchy)) continue;
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private Collection<String> getBeanNamesForType(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            this.collectBeanNamesForType(result, (ListableBeanFactory)beanFactory, ClassUtils.forName((String)type, (ClassLoader)classLoader), considerHierarchy);
            return result;
        }
        catch (ClassNotFoundException ex) {
            return Collections.emptySet();
        }
    }

    private void collectBeanNamesForType(Set<String> result, ListableBeanFactory beanFactory, Class<?> type, boolean considerHierarchy) {
        BeanFactory parent;
        result.addAll(Arrays.asList(beanFactory.getBeanNamesForType(type, true, false)));
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.collectBeanNamesForTypeFromFactoryBeans(result, (ConfigurableListableBeanFactory)beanFactory, type);
        }
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForType(result, (ListableBeanFactory)parent, type, considerHierarchy);
        }
    }

    private void collectBeanNamesForTypeFromFactoryBeans(Set<String> result, ConfigurableListableBeanFactory beanFactory, Class<?> type) {
        String[] names;
        for (String name : names = beanFactory.getBeanNamesForType(FactoryBean.class, true, false)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name = BeanFactoryUtils.transformedBeanName((String)name));
            Class<?> generic = this.getFactoryBeanGeneric(beanFactory, beanDefinition, name);
            if (generic == null || !ClassUtils.isAssignable(type, generic)) continue;
            result.add(name);
        }
    }

    private Class<?> getFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) {
        try {
            if (StringUtils.hasLength((String)definition.getFactoryBeanName()) && StringUtils.hasLength((String)definition.getFactoryMethodName())) {
                return this.getConfigurationClassFactoryBeanGeneric(beanFactory, definition, name);
            }
            if (StringUtils.hasLength((String)definition.getBeanClassName())) {
                return this.getDirectFactoryBeanGeneric(beanFactory, definition, name);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return null;
    }

    private Class<?> getConfigurationClassFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) throws Exception {
        BeanDefinition factoryDefinition = beanFactory.getBeanDefinition(definition.getFactoryBeanName());
        Class factoryClass = ClassUtils.forName((String)factoryDefinition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        Method method = ReflectionUtils.findMethod((Class)factoryClass, (String)definition.getFactoryMethodName());
        Class generic = ResolvableType.forMethodReturnType((Method)method).as(FactoryBean.class).resolveGeneric(new int[0]);
        if ((generic == null || generic.equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = (Class)definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE);
        }
        return generic;
    }

    private Class<?> getDirectFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) throws ClassNotFoundException, LinkageError {
        Class factoryBeanClass = ClassUtils.forName((String)definition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        Class generic = ResolvableType.forClass((Class)factoryBeanClass).as(FactoryBean.class).resolveGeneric(new int[0]);
        if ((generic == null || generic.equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = (Class)definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE);
        }
        return generic;
    }

    private String[] getBeanNamesForAnnotation(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        String[] result = NO_BEANS;
        try {
            Class typeClass = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            result = beanFactory.getBeanNamesForAnnotation(typeClass);
            if (considerHierarchy && beanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
                String[] parentResult = this.getBeanNamesForAnnotation((ConfigurableListableBeanFactory)beanFactory.getParentBeanFactory(), type, classLoader, true);
                ArrayList<String> resultList = new ArrayList<String>();
                resultList.addAll(Arrays.asList(result));
                for (String beanName : parentResult) {
                    if (resultList.contains(beanName) || beanFactory.containsLocalBean(beanName)) continue;
                    resultList.add(beanName);
                }
                result = StringUtils.toStringArray(resultList);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            return NO_BEANS;
        }
    }

    private static class BeanSearchSpec {
        private final List<String> names = new ArrayList<String>();
        private final List<String> types = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();
        private final SearchStrategy strategy;

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "name", this.names);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "annotation", this.annotations);
            if (this.types.isEmpty() && this.names.isEmpty()) {
                this.addDeducedBeanType(context, metadata, this.types);
            }
            Assert.isTrue((boolean)this.hasAtLeastOne(this.types, this.names, this.annotations), (String)(this.annotationName(annotationType) + " annotations must " + "specify at least one bean (type, name or annotation)"));
            this.strategy = (SearchStrategy)((Object)metadata.getAnnotationAttributes(annotationType.getName()).get("search"));
        }

        private boolean hasAtLeastOne(List<?> ... lists) {
            for (List<?> list : lists) {
                if (list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private String annotationName(Class<?> annotationType) {
            return "@" + ClassUtils.getShortName(annotationType);
        }

        private void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List valueList = (List)attributes.get((Object)key);
            Iterator i$ = valueList.iterator();
            while (i$.hasNext()) {
                String[] valueArray;
                for (String value : valueArray = (String[])i$.next()) {
                    destination.add(value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, final List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                try {
                    final MethodMetadata methodMetadata = (MethodMetadata)metadata;
                    Class configClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), (ClassLoader)context.getClassLoader());
                    ReflectionUtils.doWithMethods((Class)configClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                            if (methodMetadata.getMethodName().equals(method.getName())) {
                                beanTypes.add(method.getReturnType().getName());
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (!this.names.isEmpty()) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                if (!this.types.isEmpty()) {
                    string.append("; ");
                }
            }
            if (!this.types.isEmpty()) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
            }
            string.append("; SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase());
            string.append(")");
            return string.toString();
        }
    }
}

