/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.autoconfigure.web.HttpMapperProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
public class JacksonAutoConfiguration {
    @Autowired
    private ListableBeanFactory beanFactory;

    @PostConstruct
    private void registerModulesWithObjectMappers() {
        Collection<Module> modules = this.getBeans(Module.class);
        for (ObjectMapper objectMapper : this.getBeans(ObjectMapper.class)) {
            objectMapper.registerModules(modules);
        }
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, type).values();
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class, JacksonProperties.class})
    static class JacksonObjectMapperBuilderAutoConfiguration {
        @Autowired
        private JacksonProperties jacksonProperties;
        @Autowired
        private HttpMapperProperties httpMapperProperties;

        JacksonObjectMapperBuilderAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Jackson2ObjectMapperBuilder.class})
        public Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder() {
            Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
            if (this.httpMapperProperties.isJsonSortKeys()) {
                builder.featuresToEnable(new Object[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS});
            }
            this.configureFeatures(builder, this.jacksonProperties.getDeserialization());
            this.configureFeatures(builder, this.jacksonProperties.getSerialization());
            this.configureFeatures(builder, this.jacksonProperties.getMapper());
            this.configureFeatures(builder, this.jacksonProperties.getParser());
            this.configureFeatures(builder, this.jacksonProperties.getGenerator());
            this.configureDateFormat(builder);
            this.configurePropertyNamingStrategy(builder);
            return builder;
        }

        private void configureFeatures(Jackson2ObjectMapperBuilder builder, Map<?, Boolean> features) {
            for (Map.Entry<?, Boolean> entry : features.entrySet()) {
                if (entry.getValue() != null && entry.getValue().booleanValue()) {
                    builder.featuresToEnable(new Object[]{entry.getKey()});
                    continue;
                }
                builder.featuresToDisable(new Object[]{entry.getKey()});
            }
        }

        private void configureDateFormat(Jackson2ObjectMapperBuilder builder) {
            String dateFormat = this.jacksonProperties.getDateFormat();
            if (dateFormat != null) {
                try {
                    Class dateFormatClass = ClassUtils.forName((String)dateFormat, null);
                    builder.dateFormat((DateFormat)BeanUtils.instantiateClass((Class)dateFormatClass));
                }
                catch (ClassNotFoundException ex) {
                    builder.dateFormat((DateFormat)new SimpleDateFormat(dateFormat));
                }
            }
        }

        private void configurePropertyNamingStrategy(Jackson2ObjectMapperBuilder builder) {
            String strategy = this.jacksonProperties.getPropertyNamingStrategy();
            if (strategy != null) {
                try {
                    this.configurePropertyNamingStrategyClass(builder, ClassUtils.forName((String)strategy, null));
                }
                catch (ClassNotFoundException ex) {
                    this.configurePropertyNamingStrategyField(builder, strategy);
                }
            }
        }

        private void configurePropertyNamingStrategyClass(Jackson2ObjectMapperBuilder builder, Class<?> propertyNamingStrategyClass) {
            builder.propertyNamingStrategy((PropertyNamingStrategy)BeanUtils.instantiateClass(propertyNamingStrategyClass));
        }

        private void configurePropertyNamingStrategyField(Jackson2ObjectMapperBuilder builder, String fieldName) {
            Field field = ReflectionUtils.findField(PropertyNamingStrategy.class, (String)fieldName, PropertyNamingStrategy.class);
            Assert.notNull((Object)field, (String)("Constant named '" + fieldName + "' not found on " + PropertyNamingStrategy.class.getName()));
            try {
                builder.propertyNamingStrategy((PropertyNamingStrategy)field.get(null));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    static class JacksonObjectMapperAutoConfiguration {
        JacksonObjectMapperAutoConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean(value={ObjectMapper.class})
        public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
            return builder.createXmlMapper(false).build();
        }
    }
}

