/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@ConditionalOnClass(value={EnableJms.class})
class JmsAnnotationDrivenConfiguration {
    @Autowired(required=false)
    private DestinationResolver destinationResolver;
    @Autowired(required=false)
    private JtaTransactionManager transactionManager;
    @Autowired
    private JmsProperties properties;

    JmsAnnotationDrivenConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"jmsListenerContainerFactory"})
    public DefaultJmsListenerContainerFactory jmsListenerContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(this.properties.isPubSubDomain()));
        if (this.transactionManager != null) {
            factory.setTransactionManager((PlatformTransactionManager)this.transactionManager);
        }
        if (this.destinationResolver != null) {
            factory.setDestinationResolver(this.destinationResolver);
        }
        return factory;
    }

    @ConditionalOnJndi
    protected static class JndiConfiguration {
        protected JndiConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DestinationResolver destinationResolver() {
            JndiDestinationResolver resolver = new JndiDestinationResolver();
            resolver.setFallbackToDynamicDestination(true);
            return resolver;
        }
    }

    @EnableJms
    @ConditionalOnMissingBean(name={"org.springframework.jms.config.internalJmsListenerAnnotationProcessor"})
    protected static class EnableJmsConfiguration {
        protected EnableJmsConfiguration() {
        }
    }
}

