/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class ActiveMQConnectionFactoryConfiguration {
    ActiveMQConnectionFactoryConfiguration() {
    }

    @Bean
    public ConnectionFactory jmsConnectionFactory(ActiveMQProperties properties) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactoryFactory(properties).createConnectionFactory(ActiveMQConnectionFactory.class);
        if (properties.isPooled()) {
            PooledConnectionFactory pool = new PooledConnectionFactory();
            pool.setConnectionFactory((Object)connectionFactory);
            return pool;
        }
        return connectionFactory;
    }
}

