/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jersey;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.ApplicationPath;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.JerseyProperties;
import org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.filter.RequestContextFilter;

@Configuration
@ConditionalOnClass(name={"org.glassfish.jersey.server.spring.SpringComponentProvider", "javax.servlet.ServletRegistration"})
@ConditionalOnBean(type={"org.glassfish.jersey.server.ResourceConfig"})
@ConditionalOnWebApplication
@AutoConfigureOrder(value=-2147483648)
@AutoConfigureBefore(value={DispatcherServletAutoConfiguration.class})
@EnableConfigurationProperties(value={JerseyProperties.class})
public class JerseyAutoConfiguration
implements WebApplicationInitializer {
    @Autowired
    private JerseyProperties jersey;
    @Autowired
    private ListableBeanFactory context;
    @Autowired
    private ResourceConfig config;
    private String path;

    @PostConstruct
    public void path() {
        this.path = JerseyAutoConfiguration.findPath((ApplicationPath)AnnotationUtils.findAnnotation(this.config.getClass(), ApplicationPath.class));
    }

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean requestContextFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RequestContextFilter());
        registration.setOrder(this.jersey.getFilter().getOrder() - 1);
        registration.setName("requestContextFilter");
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean(name={"jerseyFilterRegistration"})
    @ConditionalOnProperty(prefix="spring.jersey", name={"type"}, havingValue="filter")
    public FilterRegistrationBean jerseyFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new ServletContainer(this.config));
        registration.setUrlPatterns(Arrays.asList(this.path));
        registration.setOrder(this.jersey.getFilter().getOrder());
        registration.addInitParameter("jersey.config.servlet.filter.contextPath", this.stripPattern(this.path));
        this.addInitParameters((RegistrationBean)registration);
        registration.setName("jerseyFilter");
        registration.setDispatcherTypes(EnumSet.allOf(DispatcherType.class));
        return registration;
    }

    private String stripPattern(String path) {
        if (path.endsWith("/*")) {
            path = path.substring(0, path.lastIndexOf("/*"));
        }
        return path;
    }

    @Bean
    @ConditionalOnMissingBean(name={"jerseyServletRegistration"})
    @ConditionalOnProperty(prefix="spring.jersey", name={"type"}, havingValue="servlet", matchIfMissing=true)
    public ServletRegistrationBean jerseyServletRegistration() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new ServletContainer(this.config), new String[]{this.path});
        this.addInitParameters((RegistrationBean)registration);
        registration.setName("jerseyServlet");
        return registration;
    }

    private void addInitParameters(RegistrationBean registration) {
        for (Map.Entry<String, String> entry : this.jersey.getInit().entrySet()) {
            registration.addInitParameter(entry.getKey(), entry.getValue());
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.setInitParameter("contextConfigLocation", "<NONE>");
    }

    private static String findPath(ApplicationPath annotation) {
        if (annotation == null) {
            return "/*";
        }
        String path = annotation.value();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path.equals("/") ? "/*" : path + "/*";
    }
}

