/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.io.File;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.validation.constraints.NotNull;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.InitParameterConfiguringServletContextInitializer;
import org.springframework.boot.context.embedded.JspServlet;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=false)
public class ServerProperties
implements EmbeddedServletContainerCustomizer,
Ordered {
    private Integer port;
    private InetAddress address;
    private String contextPath;
    private String displayName = "application";
    private Session session = new Session();
    @NestedConfigurationProperty
    private Ssl ssl;
    @NotNull
    private String servletPath = "/";
    private final Tomcat tomcat = new Tomcat();
    private final Undertow undertow = new Undertow();
    @NestedConfigurationProperty
    private Compression compression = new Compression();
    @NestedConfigurationProperty
    private JspServlet jspServlet;
    private final Map<String, String> contextParameters = new HashMap<String, String>();

    public int getOrder() {
        return 0;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public Undertow getUndertow() {
        return this.undertow;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = this.cleanContextPath(contextPath);
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getServletMapping() {
        if (this.servletPath.equals("") || this.servletPath.equals("/")) {
            return "/";
        }
        if (this.servletPath.contains("*")) {
            return this.servletPath;
        }
        if (this.servletPath.endsWith("/")) {
            return this.servletPath + "*";
        }
        return this.servletPath + "/*";
    }

    public String getServletPrefix() {
        String result = this.servletPath;
        if (result.contains("*")) {
            result = result.substring(0, result.indexOf("*"));
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="server.session.timeout")
    public Integer getSessionTimeout() {
        return this.session.getTimeout();
    }

    @Deprecated
    public void setSessionTimeout(Integer sessionTimeout) {
        this.session.setTimeout(sessionTimeout);
    }

    public Session getSession() {
        return this.session;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public JspServlet getJspServlet() {
        return this.jspServlet;
    }

    public void setJspServlet(JspServlet jspServlet) {
        this.jspServlet = jspServlet;
    }

    public Map<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public void setLoader(String value) {
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (this.getPort() != null) {
            container.setPort(this.getPort().intValue());
        }
        if (this.getAddress() != null) {
            container.setAddress(this.getAddress());
        }
        if (this.getContextPath() != null) {
            container.setContextPath(this.getContextPath());
        }
        if (this.getDisplayName() != null) {
            container.setDisplayName(this.getDisplayName());
        }
        if (this.getSession().getTimeout() != null) {
            container.setSessionTimeout(this.getSession().getTimeout().intValue());
        }
        container.setPersistSession(this.getSession().isPersistent());
        if (this.getSsl() != null) {
            container.setSsl(this.getSsl());
        }
        if (this.getJspServlet() != null) {
            container.setJspServlet(this.getJspServlet());
        }
        if (this.getCompression() != null) {
            container.setCompression(this.getCompression());
        }
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            this.getTomcat().customizeTomcat((TomcatEmbeddedServletContainerFactory)container);
        }
        if (container instanceof UndertowEmbeddedServletContainerFactory) {
            this.getUndertow().customizeUndertow((UndertowEmbeddedServletContainerFactory)container);
        }
        container.addInitializers(new ServletContextInitializer[]{new SessionConfiguringInitializer(this.session)});
        container.addInitializers(new ServletContextInitializer[]{new InitParameterConfiguringServletContextInitializer(this.getContextParameters())});
    }

    public String[] getPathsArray(Collection<String> paths) {
        String[] result = new String[paths.size()];
        int i = 0;
        for (String path : paths) {
            result[i++] = this.getPath(path);
        }
        return result;
    }

    public String[] getPathsArray(String[] paths) {
        String[] result = new String[paths.length];
        int i = 0;
        for (String path : paths) {
            result[i++] = this.getPath(path);
        }
        return result;
    }

    public String getPath(String path) {
        String prefix = this.getServletPrefix();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return prefix + path;
    }

    private static class SessionConfiguringInitializer
    implements ServletContextInitializer {
        private final Session session;

        public SessionConfiguringInitializer(Session session) {
            this.session = session;
        }

        public void onStartup(ServletContext servletContext) throws ServletException {
            if (this.session.getTrackingModes() != null) {
                servletContext.setSessionTrackingModes(this.session.getTrackingModes());
            }
            this.configureSessionCookie(servletContext.getSessionCookieConfig());
        }

        private void configureSessionCookie(SessionCookieConfig config) {
            Session.Cookie cookie = this.session.getCookie();
            if (cookie.getName() != null) {
                config.setName(cookie.getName());
            }
            if (cookie.getDomain() != null) {
                config.setDomain(cookie.getDomain());
            }
            if (cookie.getPath() != null) {
                config.setPath(cookie.getPath());
            }
            if (cookie.getComment() != null) {
                config.setComment(cookie.getComment());
            }
            if (cookie.getHttpOnly() != null) {
                config.setHttpOnly(cookie.getHttpOnly().booleanValue());
            }
            if (cookie.getSecure() != null) {
                config.setSecure(cookie.getSecure().booleanValue());
            }
            if (cookie.getMaxAge() != null) {
                config.setMaxAge(cookie.getMaxAge().intValue());
            }
        }
    }

    public static class Undertow {
        private Integer bufferSize;
        private Integer buffersPerRegion;
        private Integer ioThreads;
        private Integer workerThreads;
        private Boolean directBuffers;
        private final Accesslog accesslog = new Accesslog();

        public Integer getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
        }

        public Integer getBuffersPerRegion() {
            return this.buffersPerRegion;
        }

        public void setBuffersPerRegion(Integer buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
        }

        public Integer getIoThreads() {
            return this.ioThreads;
        }

        public void setIoThreads(Integer ioThreads) {
            this.ioThreads = ioThreads;
        }

        public Integer getWorkerThreads() {
            return this.workerThreads;
        }

        public void setWorkerThreads(Integer workerThreads) {
            this.workerThreads = workerThreads;
        }

        public Boolean getDirectBuffers() {
            return this.directBuffers;
        }

        public void setDirectBuffers(Boolean directBuffers) {
            this.directBuffers = directBuffers;
        }

        public Accesslog getAccesslog() {
            return this.accesslog;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="server.undertow.accesslog.pattern")
        public String getAccessLogPattern() {
            return this.accesslog.getPattern();
        }

        @Deprecated
        public void setAccessLogPattern(String accessLogPattern) {
            this.accesslog.setPattern(accessLogPattern);
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="server.undertow.accesslog.enabled")
        public boolean isAccessLogEnabled() {
            return this.accesslog.isEnabled();
        }

        @Deprecated
        public void setAccessLogEnabled(boolean accessLogEnabled) {
            this.getAccesslog().setEnabled(accessLogEnabled);
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="server.undertow.accesslog.dir")
        public File getAccessLogDir() {
            return this.accesslog.getDir();
        }

        @Deprecated
        public void setAccessLogDir(File accessLogDir) {
            this.getAccesslog().setDir(accessLogDir);
        }

        void customizeUndertow(UndertowEmbeddedServletContainerFactory factory) {
            factory.setBufferSize(this.bufferSize);
            factory.setBuffersPerRegion(this.buffersPerRegion);
            factory.setIoThreads(this.ioThreads);
            factory.setWorkerThreads(this.workerThreads);
            factory.setDirectBuffers(this.directBuffers);
            factory.setAccessLogDirectory(this.accesslog.dir);
            factory.setAccessLogPattern(this.accesslog.pattern);
            factory.setAccessLogEnabled(this.accesslog.enabled);
        }

        public static class Accesslog {
            private boolean enabled = false;
            private String pattern = "common";
            private File dir = new File("logs");

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public File getDir() {
                return this.dir;
            }

            public void setDir(File dir) {
                this.dir = dir;
            }
        }
    }

    public static class Tomcat {
        private final Accesslog accesslog = new Accesslog();
        private String internalProxies = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}";
        private String protocolHeader;
        private String protocolHeaderHttpsValue = "https";
        private String portHeader;
        private String remoteIpHeader;
        private File basedir;
        private int backgroundProcessorDelay = 30;
        private int maxThreads = 0;
        private int maxHttpHeaderSize = 0;
        private Charset uriEncoding;

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public int getMaxHttpHeaderSize() {
            return this.maxHttpHeaderSize;
        }

        public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
            this.maxHttpHeaderSize = maxHttpHeaderSize;
        }

        public Accesslog getAccesslog() {
            return this.accesslog;
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="server.tomcat.accesslog.enabled")
        public boolean getAccessLogEnabled() {
            return this.accesslog.isEnabled();
        }

        @Deprecated
        public void setAccessLogEnabled(boolean accessLogEnabled) {
            this.getAccesslog().setEnabled(accessLogEnabled);
        }

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="server.tomcat.accesslog.pattern")
        public String getAccessLogPattern() {
            return this.accesslog.getPattern();
        }

        @Deprecated
        public void setAccessLogPattern(String accessLogPattern) {
            this.accesslog.setPattern(accessLogPattern);
        }

        public int getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getInternalProxies() {
            return this.internalProxies;
        }

        public void setInternalProxies(String internalProxies) {
            this.internalProxies = internalProxies;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getProtocolHeaderHttpsValue() {
            return this.protocolHeaderHttpsValue;
        }

        public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
            this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
        }

        public String getPortHeader() {
            return this.portHeader;
        }

        public void setPortHeader(String portHeader) {
            this.portHeader = portHeader;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        public Charset getUriEncoding() {
            return this.uriEncoding;
        }

        public void setUriEncoding(Charset uriEncoding) {
            this.uriEncoding = uriEncoding;
        }

        void customizeTomcat(TomcatEmbeddedServletContainerFactory factory) {
            if (this.getBasedir() != null) {
                factory.setBaseDirectory(this.getBasedir());
            }
            this.customizeBackgroundProcessorDelay(factory);
            this.customizeHeaders(factory);
            if (this.maxThreads > 0) {
                this.customizeMaxThreads(factory);
            }
            if (this.maxHttpHeaderSize > 0) {
                this.customizeMaxHttpHeaderSize(factory);
            }
            if (this.accesslog.enabled) {
                this.customizeAccessLog(factory);
            }
            if (this.getUriEncoding() != null) {
                factory.setUriEncoding(this.getUriEncoding());
            }
        }

        private void customizeBackgroundProcessorDelay(TomcatEmbeddedServletContainerFactory factory) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                public void customize(Context context) {
                    context.setBackgroundProcessorDelay(Tomcat.this.backgroundProcessorDelay);
                }
            }});
        }

        private void customizeHeaders(TomcatEmbeddedServletContainerFactory factory) {
            String remoteIpHeader = this.getRemoteIpHeader();
            String protocolHeader = this.getProtocolHeader();
            if (StringUtils.hasText((String)remoteIpHeader) || StringUtils.hasText((String)protocolHeader)) {
                RemoteIpValve valve = new RemoteIpValve();
                valve.setRemoteIpHeader(remoteIpHeader);
                valve.setProtocolHeader(protocolHeader);
                valve.setInternalProxies(this.getInternalProxies());
                valve.setPortHeader(this.getPortHeader());
                valve.setProtocolHeaderHttpsValue(this.getProtocolHeaderHttpsValue());
                factory.addContextValves(new Valve[]{valve});
            }
        }

        private void customizeMaxThreads(TomcatEmbeddedServletContainerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractProtocol) {
                        AbstractProtocol protocol = (AbstractProtocol)handler;
                        protocol.setMaxThreads(Tomcat.this.maxThreads);
                    }
                }
            }});
        }

        private void customizeMaxHttpHeaderSize(TomcatEmbeddedServletContainerFactory factory) {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new TomcatConnectorCustomizer(){

                public void customize(Connector connector) {
                    ProtocolHandler handler = connector.getProtocolHandler();
                    if (handler instanceof AbstractHttp11Protocol) {
                        AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                        protocol.setMaxHttpHeaderSize(Tomcat.this.maxHttpHeaderSize);
                    }
                }
            }});
        }

        private void customizeAccessLog(TomcatEmbeddedServletContainerFactory factory) {
            factory.addContextValves(new Valve[]{this.accesslog.createAccessLogValve()});
        }

        public static class Accesslog {
            private boolean enabled = false;
            private String pattern = "common";
            private String directory = "logs";
            protected String prefix = "access_log";
            private String suffix = ".log";

            AccessLogValve createAccessLogValve() {
                AccessLogValve valve = new AccessLogValve();
                valve.setPattern(this.pattern);
                valve.setDirectory(this.directory);
                valve.setPrefix(this.prefix);
                valve.setSuffix(this.suffix);
                return valve;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }
        }
    }

    public static class Session {
        private Integer timeout;
        private Set<SessionTrackingMode> trackingModes;
        private boolean persistent;
        private Cookie cookie = new Cookie();

        public Cookie getCookie() {
            return this.cookie;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer sessionTimeout) {
            this.timeout = sessionTimeout;
        }

        public Set<SessionTrackingMode> getTrackingModes() {
            return this.trackingModes;
        }

        public void setTrackingModes(Set<SessionTrackingMode> trackingModes) {
            this.trackingModes = trackingModes;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        public static class Cookie {
            private String name;
            private String domain;
            private String path;
            private String comment;
            private Boolean httpOnly;
            private Boolean secure;
            private Integer maxAge;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getDomain() {
                return this.domain;
            }

            public void setDomain(String domain) {
                this.domain = domain;
            }

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public String getComment() {
                return this.comment;
            }

            public void setComment(String comment) {
                this.comment = comment;
            }

            public Boolean getHttpOnly() {
                return this.httpOnly;
            }

            public void setHttpOnly(Boolean httpOnly) {
                this.httpOnly = httpOnly;
            }

            public Boolean getSecure() {
                return this.secure;
            }

            public void setSecure(Boolean secure) {
                this.secure = secure;
            }

            public Integer getMaxAge() {
                return this.maxAge;
            }

            public void setMaxAge(Integer maxAge) {
                this.maxAge = maxAge;
            }
        }
    }
}

