/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template;

import groovy.text.markup.MarkupTemplateEngine;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateProperties;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfig;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;

@Configuration
@ConditionalOnClass(value={MarkupTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={GroovyTemplateProperties.class})
public class GroovyTemplateAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Servlet.class, LocaleContextHolder.class, UrlBasedViewResolver.class})
    @ConditionalOnWebApplication
    @ConditionalOnProperty(name={"spring.groovy.template.enabled"}, matchIfMissing=true)
    public static class GroovyWebConfiguration {
        @Autowired
        private GroovyTemplateProperties properties;

        @Bean
        @ConditionalOnMissingBean(name={"groovyMarkupViewResolver"})
        public GroovyMarkupViewResolver groovyMarkupViewResolver() {
            GroovyMarkupViewResolver resolver = new GroovyMarkupViewResolver();
            this.properties.applyToViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnClass(value={GroovyMarkupConfigurer.class})
    public static class GroovyMarkupConfiguration {
        @Autowired
        private ApplicationContext applicationContext;
        @Autowired
        private GroovyTemplateProperties properties;
        @Autowired(required=false)
        private MarkupTemplateEngine templateEngine;

        @PostConstruct
        public void checkTemplateLocationExists() {
            if (this.properties.isCheckTemplateLocation() && !this.isUsingGroovyAllJar()) {
                TemplateLocation location = new TemplateLocation(this.properties.getResourceLoaderPath());
                Assert.state((boolean)location.exists((ResourcePatternResolver)this.applicationContext), (String)("Cannot find template location: " + location + " (please add some templates, check your Groovy " + "configuration, or set spring.groovy.template." + "check-template-location=false)"));
            }
        }

        private boolean isUsingGroovyAllJar() {
            try {
                ProtectionDomain domain = MarkupTemplateEngine.class.getProtectionDomain();
                CodeSource codeSource = domain.getCodeSource();
                if (codeSource != null && codeSource.getLocation().toString().contains("-all")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Bean
        @ConditionalOnMissingBean(value={GroovyMarkupConfig.class})
        @ConfigurationProperties(prefix="spring.groovy.template.configuration")
        public GroovyMarkupConfigurer groovyMarkupConfigurer() {
            GroovyMarkupConfigurer configurer = new GroovyMarkupConfigurer();
            configurer.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            configurer.setCacheTemplates(this.properties.isCache());
            if (this.templateEngine != null) {
                configurer.setTemplateEngine(this.templateEngine);
            }
            return configurer;
        }
    }
}

