/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigResourceCondition;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastInstanceFactory;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={HazelcastInstance.class})
@ConditionalOnMissingBean(value={HazelcastInstance.class})
@EnableConfigurationProperties(value={HazelcastProperties.class})
public class HazelcastAutoConfiguration {

    static class ConfigAvailableCondition
    extends HazelcastConfigResourceCondition {
        public ConfigAvailableCondition() {
            super("spring.hazelcast", "config");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={HazelcastInstance.class})
    @ConditionalOnSingleCandidate(value=Config.class)
    static class HazelcastConfigConfiguration {
        HazelcastConfigConfiguration() {
        }

        @Bean
        public HazelcastInstance hazelcastInstance(Config config) {
            return new HazelcastInstanceFactory(config).getHazelcastInstance();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={HazelcastInstance.class, Config.class})
    @Conditional(value={ConfigAvailableCondition.class})
    static class HazelcastConfigFileConfiguration {
        @Autowired
        private HazelcastProperties hazelcastProperties;

        HazelcastConfigFileConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public HazelcastInstance hazelcastInstance() throws IOException {
            Resource config = this.hazelcastProperties.resolveConfigLocation();
            if (config != null) {
                return new HazelcastInstanceFactory(config).getHazelcastInstance();
            }
            return Hazelcast.newHazelcastInstance();
        }
    }
}

