/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.SpringBootWebSecurityConfiguration;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties
@AutoConfigureAfter(value={SpringBootWebSecurityConfiguration.class})
public class SecurityFilterAutoConfiguration {
    private static final String DEFAULT_FILTER_NAME = "springSecurityFilterChain";

    @Bean
    @ConditionalOnBean(name={"springSecurityFilterChain"})
    public FilterRegistrationBean securityFilterChainRegistration(@Qualifier(value="springSecurityFilterChain") Filter securityFilter, SecurityProperties securityProperties) {
        FilterRegistrationBean registration = new FilterRegistrationBean(securityFilter, new ServletRegistrationBean[0]);
        registration.setOrder(securityProperties.getFilterOrder());
        registration.setName(DEFAULT_FILTER_NAME);
        return registration;
    }
}

