/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

class SsoSecurityConfigurer {
    private BeanFactory beanFactory;

    public SsoSecurityConfigurer(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void configure(HttpSecurity http) throws Exception {
        OAuth2SsoProperties sso = (OAuth2SsoProperties)this.beanFactory.getBean(OAuth2SsoProperties.class);
        http.apply((SecurityConfigurerAdapter)new OAuth2ClientAuthenticationConfigurer(this.oauth2SsoFilter(sso)));
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(sso.getLoginPath()));
    }

    private OAuth2ClientAuthenticationProcessingFilter oauth2SsoFilter(OAuth2SsoProperties sso) {
        OAuth2RestOperations restTemplate = (OAuth2RestOperations)this.beanFactory.getBean(OAuth2RestOperations.class);
        ResourceServerTokenServices tokenServices = (ResourceServerTokenServices)this.beanFactory.getBean(ResourceServerTokenServices.class);
        OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(sso.getLoginPath());
        filter.setRestTemplate(restTemplate);
        filter.setTokenServices(tokenServices);
        return filter;
    }

    private static class OAuth2ClientAuthenticationConfigurer
    extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
        private OAuth2ClientAuthenticationProcessingFilter filter;

        public OAuth2ClientAuthenticationConfigurer(OAuth2ClientAuthenticationProcessingFilter filter) {
            this.filter = filter;
        }

        public void configure(HttpSecurity builder) throws Exception {
            OAuth2ClientAuthenticationProcessingFilter ssoFilter = this.filter;
            ssoFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)builder.getSharedObject(SessionAuthenticationStrategy.class));
            builder.addFilterAfter((Filter)ssoFilter, AbstractPreAuthenticatedProcessingFilter.class);
        }
    }
}

