/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.guava.GuavaCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={CacheBuilder.class, GuavaCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@Conditional(value={CacheCondition.class})
class GuavaCacheConfiguration {
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired(required=false)
    private CacheBuilder<Object, Object> cacheBuilder;
    @Autowired(required=false)
    private CacheBuilderSpec cacheBuilderSpec;
    @Autowired(required=false)
    private CacheLoader<Object, Object> cacheLoader;

    GuavaCacheConfiguration() {
    }

    @Bean
    public GuavaCacheManager cacheManager() {
        GuavaCacheManager cacheManager = this.createCacheManager();
        List<String> cacheNames = this.cacheProperties.getCacheNames();
        if (!CollectionUtils.isEmpty(cacheNames)) {
            cacheManager.setCacheNames(cacheNames);
        }
        return cacheManager;
    }

    private GuavaCacheManager createCacheManager() {
        GuavaCacheManager cacheManager = new GuavaCacheManager();
        this.setCacheBuilder(cacheManager);
        if (this.cacheLoader != null) {
            cacheManager.setCacheLoader(this.cacheLoader);
        }
        return cacheManager;
    }

    private void setCacheBuilder(GuavaCacheManager cacheManager) {
        String specification = this.cacheProperties.getGuava().getSpec();
        if (StringUtils.hasText((String)specification)) {
            cacheManager.setCacheSpecification(specification);
        } else if (this.cacheBuilderSpec != null) {
            cacheManager.setCacheBuilderSpec(this.cacheBuilderSpec);
        } else if (this.cacheBuilder != null) {
            cacheManager.setCacheBuilder(this.cacheBuilder);
        }
    }
}

