/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.java.CouchbaseBucket;
import java.util.List;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.data.couchbase.config.AbstractCouchbaseConfiguration;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.mapping.event.ValidatingCouchbaseEventListener;
import org.springframework.data.couchbase.core.query.Consistency;
import org.springframework.data.couchbase.repository.support.IndexManager;

@Configuration
@ConditionalOnClass(value={CouchbaseBucket.class, AbstractCouchbaseConfiguration.class})
@Conditional(value={CouchbaseCondition.class})
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class CouchbaseAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Validator.class})
    public ValidatingCouchbaseEventListener validationEventListener(Validator validator) {
        return new ValidatingCouchbaseEventListener(validator);
    }

    static class CouchbaseCondition
    extends AnyNestedCondition {
        CouchbaseCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={AbstractCouchbaseConfiguration.class})
        static class CouchbaseConfiguration {
            CouchbaseConfiguration() {
            }
        }

        @ConditionalOnProperty(prefix="spring.data.couchbase.bucket", name={"name"})
        static class BucketNameProperty {
            BucketNameProperty() {
            }
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={AbstractCouchbaseConfiguration.class})
    public static class CouchbaseConfiguration
    extends AbstractCouchbaseConfiguration {
        @Autowired
        private CouchbaseProperties properties;

        protected List<String> getBootstrapHosts() {
            return this.properties.getBootstrapHosts();
        }

        protected String getBucketName() {
            return this.properties.getBucket().getName();
        }

        protected String getBucketPassword() {
            return this.properties.getBucket().getPassword();
        }

        protected Consistency getDefaultConsistency() {
            return this.properties.getConsistency();
        }

        @ConditionalOnMissingBean(name={"couchbaseTemplate"})
        @Bean(name={"couchbaseTemplate"})
        public CouchbaseTemplate couchbaseTemplate() throws Exception {
            return super.couchbaseTemplate();
        }

        @ConditionalOnMissingBean(name={"couchbaseIndexManager"})
        @Bean(name={"couchbaseIndexManager"})
        public IndexManager indexManager() {
            if (this.properties.isAutoIndex()) {
                return new IndexManager(true, true, true);
            }
            return new IndexManager(false, false, false);
        }
    }
}

