/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.solr;

import java.io.IOException;
import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.solr.SolrProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={HttpSolrClient.class, CloudSolrClient.class})
@EnableConfigurationProperties(value={SolrProperties.class})
public class SolrAutoConfiguration {
    @Autowired
    private SolrProperties properties;
    private SolrClient solrClient;

    @PreDestroy
    public void close() throws IOException {
        if (this.solrClient != null) {
            this.solrClient.close();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SolrClient solrClient() {
        this.solrClient = this.createSolrClient();
        return this.solrClient;
    }

    private SolrClient createSolrClient() {
        if (StringUtils.hasText((String)this.properties.getZkHost())) {
            return new CloudSolrClient(this.properties.getZkHost());
        }
        return new HttpSolrClient(this.properties.getHost());
    }
}

