/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;

@Configuration
@ConditionalOnClass(value={Cluster.class, CassandraAdminOperations.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
@AutoConfigureAfter(value={CassandraAutoConfiguration.class})
public class CassandraDataAutoConfiguration {
    private final CassandraProperties properties;
    private final Cluster cluster;

    public CassandraDataAutoConfiguration(CassandraProperties properties, Cluster cluster) {
        this.properties = properties;
        this.cluster = cluster;
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraMappingContext cassandraMapping() {
        return new BasicCassandraMappingContext();
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraConverter cassandraConverter(CassandraMappingContext mapping) {
        return new MappingCassandraConverter(mapping);
    }

    @Bean
    @ConditionalOnMissingBean(value={Session.class})
    public CassandraSessionFactoryBean session(CassandraConverter converter) throws Exception {
        CassandraSessionFactoryBean session = new CassandraSessionFactoryBean();
        session.setCluster(this.cluster);
        session.setConverter(converter);
        session.setKeyspaceName(this.properties.getKeyspaceName());
        session.setSchemaAction(SchemaAction.NONE);
        return session;
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraTemplate cassandraTemplate(Session session, CassandraConverter converter) throws Exception {
        return new CassandraTemplate(session, converter);
    }
}

