/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.session.Session;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;

@Configuration
@ConditionalOnClass(value={Session.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class SessionAutoConfiguration {

    @EnableConfigurationProperties
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean(value={RedisHttpSessionConfiguration.class})
    @EnableRedisHttpSession
    @Configuration
    public static class SessionRedisHttpConfiguration {
        private final ServerProperties serverProperties;
        private final RedisOperationsSessionRepository sessionRepository;

        public SessionRedisHttpConfiguration(ServerProperties serverProperties, RedisOperationsSessionRepository sessionRepository) {
            this.serverProperties = serverProperties;
            this.sessionRepository = sessionRepository;
            this.applyConfigurationProperties();
        }

        private void applyConfigurationProperties() {
            Integer timeout = this.serverProperties.getSession().getTimeout();
            if (timeout != null) {
                this.sessionRepository.setDefaultMaxInactiveInterval(timeout.intValue());
            }
        }

        @Configuration
        @ConditionalOnMissingBean(value={ServerProperties.class}, search=SearchStrategy.CURRENT)
        public static class ServerPropertiesConfiguration {
            @Bean
            public ServerProperties serverProperties() {
                return new ServerProperties();
            }
        }
    }
}

