/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializedEvent;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

class DataSourceInitializer
implements ApplicationListener<DataSourceInitializedEvent> {
    private static final Log logger = LogFactory.getLog(DataSourceInitializer.class);
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    private DataSource dataSource;
    @Autowired
    private DataSourceProperties properties;
    private boolean initialized = false;

    DataSourceInitializer() {
    }

    @PostConstruct
    public void init() {
        if (!this.properties.isInitialize()) {
            logger.debug((Object)"Initialization disabled (not running DDL scripts)");
            return;
        }
        if (this.applicationContext.getBeanNamesForType(DataSource.class, false, false).length > 0) {
            this.dataSource = (DataSource)this.applicationContext.getBean(DataSource.class);
        }
        if (this.dataSource == null) {
            logger.debug((Object)"No DataSource found so not initializing");
            return;
        }
        this.runSchemaScripts();
    }

    private void runSchemaScripts() {
        List<Resource> scripts = this.getScripts(this.properties.getSchema(), "schema");
        if (!scripts.isEmpty()) {
            String username = this.properties.getSchemaUsername();
            String password = this.properties.getSchemaPassword();
            this.runScripts(scripts, username, password);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)new DataSourceInitializedEvent(this.dataSource));
                if (!this.initialized) {
                    this.runDataScripts();
                    this.initialized = true;
                }
            }
            catch (IllegalStateException ex) {
                logger.warn((Object)("Could not send event to complete DataSource initialization (" + ex.getMessage() + ")"));
            }
        }
    }

    public void onApplicationEvent(DataSourceInitializedEvent event) {
        if (!this.properties.isInitialize()) {
            logger.debug((Object)"Initialization disabled (not running data scripts)");
            return;
        }
        if (!this.initialized) {
            this.runDataScripts();
            this.initialized = true;
        }
    }

    private void runDataScripts() {
        List<Resource> scripts = this.getScripts(this.properties.getData(), "data");
        String username = this.properties.getDataUsername();
        String password = this.properties.getDataPassword();
        this.runScripts(scripts, username, password);
    }

    private List<Resource> getScripts(String locations, String fallback) {
        if (locations == null) {
            String platform = this.properties.getPlatform();
            locations = "classpath*:" + fallback + "-" + platform + ".sql,";
            locations = locations + "classpath*:" + fallback + ".sql";
        }
        return this.getResources(locations);
    }

    private List<Resource> getResources(String locations) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : StringUtils.commaDelimitedListToStringArray((String)locations)) {
            try {
                for (Resource resource : this.applicationContext.getResources(location)) {
                    if (!resource.exists()) continue;
                    resources.add(resource);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to load resource from " + location, ex);
            }
        }
        return resources;
    }

    private void runScripts(List<Resource> resources, String username, String password) {
        if (resources.isEmpty()) {
            return;
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(this.properties.isContinueOnError());
        populator.setSeparator(this.properties.getSeparator());
        if (this.properties.getSqlScriptEncoding() != null) {
            populator.setSqlScriptEncoding(this.properties.getSqlScriptEncoding().name());
        }
        for (Resource resource : resources) {
            populator.addScript(resource);
        }
        DataSource dataSource = this.dataSource;
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            dataSource = DataSourceBuilder.create(this.properties.getClassLoader()).driverClassName(this.properties.determineDriverClassName()).url(this.properties.determineUrl()).username(username).password(password).build();
        }
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
    }
}

