/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import java.util.Collection;
import java.util.List;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.config.impl.JMSConfigurationImpl;
import org.hornetq.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.hornetq.jms.server.config.impl.TopicConfigurationImpl;
import org.hornetq.jms.server.embedded.EmbeddedJMS;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQConfigurationCustomizer;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQEmbeddedConfigurationFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQNoOpBindingRegistry;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration
@ConditionalOnClass(name={"org.hornetq.jms.server.embedded.EmbeddedJMS"})
@ConditionalOnProperty(prefix="spring.hornetq.embedded", name={"enabled"}, havingValue="true", matchIfMissing=true)
class HornetQEmbeddedServerConfiguration {
    private final HornetQProperties properties;
    private final List<HornetQConfigurationCustomizer> configurationCustomizers;
    private final List<JMSQueueConfiguration> queuesConfiguration;
    private final List<TopicConfiguration> topicsConfiguration;

    HornetQEmbeddedServerConfiguration(HornetQProperties properties, ObjectProvider<List<HornetQConfigurationCustomizer>> configurationCustomizersProvider, ObjectProvider<List<JMSQueueConfiguration>> queuesConfigurationProvider, ObjectProvider<List<TopicConfiguration>> topicsConfigurationProvider) {
        this.properties = properties;
        this.configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
        this.queuesConfiguration = (List)queuesConfigurationProvider.getIfAvailable();
        this.topicsConfiguration = (List)topicsConfigurationProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public org.hornetq.core.config.Configuration hornetQConfiguration() {
        return new HornetQEmbeddedConfigurationFactory(this.properties).createConfiguration();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public EmbeddedJMS hornetQServer(org.hornetq.core.config.Configuration configuration, JMSConfiguration jmsConfiguration) {
        EmbeddedJMS server = new EmbeddedJMS();
        this.customize(configuration);
        server.setConfiguration(configuration);
        server.setJmsConfiguration(jmsConfiguration);
        server.setRegistry((BindingRegistry)new HornetQNoOpBindingRegistry());
        return server;
    }

    private void customize(org.hornetq.core.config.Configuration configuration) {
        if (this.configurationCustomizers != null) {
            AnnotationAwareOrderComparator.sort(this.configurationCustomizers);
            for (HornetQConfigurationCustomizer customizer : this.configurationCustomizers) {
                customizer.customize(configuration);
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public JMSConfiguration hornetQJmsConfiguration() {
        JMSConfigurationImpl configuration = new JMSConfigurationImpl();
        this.addAll(configuration.getQueueConfigurations(), this.queuesConfiguration);
        this.addAll(configuration.getTopicConfigurations(), this.topicsConfiguration);
        this.addQueues((JMSConfiguration)configuration, this.properties.getEmbedded().getQueues());
        this.addTopics((JMSConfiguration)configuration, this.properties.getEmbedded().getTopics());
        return configuration;
    }

    private <T> void addAll(List<T> list, Collection<? extends T> items) {
        if (items != null) {
            list.addAll(items);
        }
    }

    private void addQueues(JMSConfiguration configuration, String[] queues) {
        boolean persistent = this.properties.getEmbedded().isPersistent();
        for (String queue : queues) {
            configuration.getQueueConfigurations().add(new JMSQueueConfigurationImpl(queue, null, persistent, new String[]{"/queue/" + queue}));
        }
    }

    private void addTopics(JMSConfiguration configuration, String[] topics) {
        for (String topic : topics) {
            configuration.getTopicConfigurations().add(new TopicConfigurationImpl(topic, new String[]{"/topic/" + topic}));
        }
    }
}

