/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.web.ErrorViewResolver;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class DefaultErrorViewResolver
implements ErrorViewResolver,
Ordered {
    private static final Map<HttpStatus.Series, String> SERIES_VIEWS;
    private static final int CACHE_LIMIT = 1024;
    private static final Object UNRESOLVED;
    private ApplicationContext applicationContext;
    private final ResourceProperties resourceProperties;
    private final List<TemplateAvailabilityProvider> templateAvailabilityProviders;
    private int order = Integer.MAX_VALUE;
    private final Map<Object, Object> resolved = new ConcurrentHashMap<Object, Object>(1024);
    private final Map<Object, Object> cache = new LinkedHashMap<Object, Object>(1024, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Object> eldest) {
            if (this.size() > 1024) {
                DefaultErrorViewResolver.this.resolved.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    };

    public DefaultErrorViewResolver(ApplicationContext applicationContext, ResourceProperties resourceProperties) {
        this(applicationContext, resourceProperties, DefaultErrorViewResolver.loadTemplateAvailabilityProviders(applicationContext));
    }

    private static List<TemplateAvailabilityProvider> loadTemplateAvailabilityProviders(ApplicationContext applicationContext) {
        return SpringFactoriesLoader.loadFactories(TemplateAvailabilityProvider.class, (ClassLoader)(applicationContext == null ? null : applicationContext.getClassLoader()));
    }

    DefaultErrorViewResolver(ApplicationContext applicationContext, ResourceProperties resourceProperties, List<TemplateAvailabilityProvider> templateAvailabilityProviders) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        Assert.notNull((Object)resourceProperties, (String)"ResourceProperties must not be null");
        this.applicationContext = applicationContext;
        this.resourceProperties = resourceProperties;
        this.templateAvailabilityProviders = templateAvailabilityProviders;
    }

    @Override
    public ModelAndView resolveErrorView(HttpServletRequest request, HttpStatus status, Map<String, Object> model) {
        ModelAndView modelAndView = this.resolve(String.valueOf(status), model);
        if (modelAndView == null && SERIES_VIEWS.containsKey(status.series())) {
            modelAndView = this.resolve(SERIES_VIEWS.get(status.series()), model);
        }
        return modelAndView;
    }

    private ModelAndView resolve(String viewName, Map<String, Object> model) {
        ModelAndView modelAndView = this.resolveTemplate(viewName, model);
        if (modelAndView == null) {
            modelAndView = this.resolveResource(viewName, model);
        }
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView resolveTemplate(String viewName, Map<String, Object> model) {
        Object resolved = this.resolved.get(viewName);
        if (resolved == null) {
            Map<Object, Object> map = this.cache;
            synchronized (map) {
                resolved = this.resolveTemplateViewName(viewName);
                resolved = resolved == null ? UNRESOLVED : resolved;
                this.resolved.put(viewName, resolved);
                this.cache.put(viewName, resolved);
            }
        }
        return resolved == UNRESOLVED ? null : new ModelAndView((String)resolved, model);
    }

    private String resolveTemplateViewName(String viewName) {
        for (TemplateAvailabilityProvider templateAvailabilityProvider : this.templateAvailabilityProviders) {
            if (!templateAvailabilityProvider.isTemplateAvailable("error/" + viewName, this.applicationContext.getEnvironment(), this.applicationContext.getClassLoader(), (ResourceLoader)this.applicationContext)) continue;
            return "error/" + viewName;
        }
        return null;
    }

    private ModelAndView resolveResource(String viewName, Map<String, Object> model) {
        for (String location : this.resourceProperties.getStaticLocations()) {
            try {
                Resource resource = this.applicationContext.getResource(location);
                resource = resource.createRelative("error/" + viewName + ".html");
                if (!resource.exists()) continue;
                return new ModelAndView((View)new HtmlResourceView(resource), model);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    static {
        HashMap<HttpStatus.Series, String> views = new HashMap<HttpStatus.Series, String>();
        views.put(HttpStatus.Series.CLIENT_ERROR, "4xx");
        views.put(HttpStatus.Series.SERVER_ERROR, "5xx");
        SERIES_VIEWS = Collections.unmodifiableMap(views);
        UNRESOLVED = new Object();
    }

    private static class HtmlResourceView
    implements View {
        private Resource resource;

        HtmlResourceView(Resource resource) {
            this.resource = resource;
        }

        public String getContentType() {
            return "text/html";
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.setContentType(this.getContentType());
            FileCopyUtils.copy((InputStream)this.resource.getInputStream(), (OutputStream)response.getOutputStream());
        }
    }
}

