/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import javax.jms.ConnectionFactory;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.boot.autoconfigure.jms.hornetq.SpringBootHornetQConnectionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class HornetQConnectionFactoryConfiguration {
    HornetQConnectionFactoryConfiguration() {
    }

    @Bean
    public HornetQConnectionFactory jmsConnectionFactory(ListableBeanFactory beanFactory, HornetQProperties properties) {
        return new HornetQConnectionFactoryFactory(beanFactory, properties).createConnectionFactory(SpringBootHornetQConnectionFactory.class);
    }
}

