/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.util.StringUtils;

class SpringBootHornetQConnectionFactory
extends HornetQConnectionFactory {
    private final HornetQProperties properties;

    SpringBootHornetQConnectionFactory(HornetQProperties properties, ServerLocator serverLocator) {
        super(serverLocator);
        this.properties = properties;
    }

    SpringBootHornetQConnectionFactory(HornetQProperties properties, boolean ha, TransportConfiguration ... initialConnectors) {
        super(ha, initialConnectors);
        this.properties = properties;
    }

    public Connection createConnection() throws JMSException {
        String user = this.properties.getUser();
        if (StringUtils.hasText((String)user)) {
            return this.createConnection(user, this.properties.getPassword());
        }
        return super.createConnection();
    }
}

