/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.SessionRepositoryFilterConfiguration;
import org.springframework.boot.autoconfigure.session.SessionStoreMappings;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

@Configuration
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnClass(value={Session.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={SessionProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HazelcastAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, RedisAutoConfiguration.class})
@Import(value={SessionConfigurationImportSelector.class, SessionRepositoryValidator.class, SessionRepositoryFilterConfiguration.class})
public class SessionAutoConfiguration {

    static class SessionRepositoryValidator {
        private SessionProperties sessionProperties;
        private ObjectProvider<SessionRepository<?>> sessionRepositoryProvider;

        SessionRepositoryValidator(SessionProperties sessionProperties, ObjectProvider<SessionRepository<?>> sessionRepositoryProvider) {
            this.sessionProperties = sessionProperties;
            this.sessionRepositoryProvider = sessionRepositoryProvider;
        }

        @PostConstruct
        public void checkSessionRepository() {
            StoreType storeType = this.sessionProperties.getStoreType();
            if (storeType != StoreType.NONE && this.sessionRepositoryProvider.getIfAvailable() == null) {
                if (storeType != null) {
                    throw new IllegalArgumentException("No session repository could be auto-configured, check your configuration (session store type is '" + storeType.name().toLowerCase() + "')");
                }
                throw new IllegalArgumentException("No Spring Session store is configured: set the 'spring.session.store-type' property");
            }
        }
    }

    static class SessionConfigurationImportSelector
    implements ImportSelector {
        SessionConfigurationImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            StoreType[] types = StoreType.values();
            String[] imports = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                imports[i] = SessionStoreMappings.getConfigurationClass(types[i]);
            }
            return imports;
        }
    }
}

