/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.session.jdbc")
public class JdbcSessionProperties {
    private static final String DEFAULT_SCHEMA_LOCATION = "classpath:org/springframework/session/jdbc/schema-@@platform@@.sql";
    private static final String DEFAULT_TABLE_NAME = "SPRING_SESSION";
    private String schema = "classpath:org/springframework/session/jdbc/schema-@@platform@@.sql";
    private String tableName = "SPRING_SESSION";
    private final Initializer initializer = new Initializer();

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Initializer getInitializer() {
        return this.initializer;
    }

    public class Initializer {
        private Boolean enabled;

        public boolean isEnabled() {
            if (this.enabled != null) {
                return this.enabled;
            }
            boolean defaultTableName = JdbcSessionProperties.DEFAULT_TABLE_NAME.equals(JdbcSessionProperties.this.getTableName());
            boolean customSchema = !JdbcSessionProperties.DEFAULT_SCHEMA_LOCATION.equals(JdbcSessionProperties.this.getSchema());
            return defaultTableName || customSchema;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

