/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http;

import com.google.gson.Gson;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@ConditionalOnClass(value={Gson.class})
class GsonHttpMessageConvertersConfiguration {
    GsonHttpMessageConvertersConfiguration() {
    }

    private static class JacksonAndJsonbUnavailable
    extends NoneNestedConditions {
        JacksonAndJsonbUnavailable() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jsonb")
        static class JsonbPreferred {
            JsonbPreferred() {
            }
        }

        @ConditionalOnBean(value={MappingJackson2HttpMessageConverter.class})
        static class JacksonMissing {
            JacksonMissing() {
            }
        }
    }

    private static class PreferGsonOrJacksonAndJsonbUnavailableCondition
    extends AnyNestedCondition {
        PreferGsonOrJacksonAndJsonbUnavailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={JacksonAndJsonbUnavailable.class})
        static class JacksonJsonbUnavailable {
            JacksonJsonbUnavailable() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="gson")
        static class GsonPreferred {
            GsonPreferred() {
            }
        }
    }

    @Configuration
    @ConditionalOnBean(value={Gson.class})
    @Conditional(value={PreferGsonOrJacksonAndJsonbUnavailableCondition.class})
    protected static class GsonHttpMessageConverterConfiguration {
        protected GsonHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public GsonHttpMessageConverter gsonHttpMessageConverter(Gson gson) {
            GsonHttpMessageConverter converter = new GsonHttpMessageConverter();
            converter.setGson(gson);
            return converter;
        }
    }
}

