/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.reactive;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.userdetails.MapReactiveUserDetailsService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@ConditionalOnClass(value={ReactiveAuthenticationManager.class})
@ConditionalOnMissingBean(value={ReactiveAuthenticationManager.class, ReactiveUserDetailsService.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class ReactiveAuthenticationManagerConfiguration {
    private static final Log logger = LogFactory.getLog(ReactiveAuthenticationManagerConfiguration.class);

    ReactiveAuthenticationManagerConfiguration() {
    }

    @Bean
    public MapReactiveUserDetailsService reactiveUserDetailsService(ObjectProvider<PasswordEncoder> passwordEncoder) {
        String password = UUID.randomUUID().toString();
        logger.info((Object)String.format("%n%nUsing default security password: %s%n", password));
        UserDetails userDetails = this.getUserDetails(password, passwordEncoder);
        return new MapReactiveUserDetailsService(new UserDetails[]{userDetails});
    }

    private UserDetails getUserDetails(String password, ObjectProvider<PasswordEncoder> passwordEncoder) {
        String encodedPassword = ((PasswordEncoder)passwordEncoder.getIfAvailable(PasswordEncoderFactories::createDelegatingPasswordEncoder)).encode((CharSequence)password);
        return User.withUsername((String)"user").password(encodedPassword).roles(new String[0]).build();
    }
}

