/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="spring.kafka")
public class KafkaProperties {
    private List<String> bootstrapServers = new ArrayList<String>(Collections.singletonList("localhost:9092"));
    private String clientId;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Consumer consumer = new Consumer();
    private final Producer producer = new Producer();
    private final Admin admin = new Admin();
    private final Listener listener = new Listener();
    private final Ssl ssl = new Ssl();
    private final Jaas jaas = new Jaas();
    private final Template template = new Template();

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(List<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Admin getAdmin() {
        return this.admin;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public Jaas getJaas() {
        return this.jaas;
    }

    public Template getTemplate() {
        return this.template;
    }

    private Map<String, Object> buildCommonProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.bootstrapServers != null) {
            properties.put("bootstrap.servers", this.bootstrapServers);
        }
        if (this.clientId != null) {
            properties.put("client.id", this.clientId);
        }
        if (this.ssl.getKeyPassword() != null) {
            properties.put("ssl.key.password", this.ssl.getKeyPassword());
        }
        if (this.ssl.getKeystoreLocation() != null) {
            properties.put("ssl.keystore.location", KafkaProperties.resourceToPath(this.ssl.getKeystoreLocation()));
        }
        if (this.ssl.getKeystorePassword() != null) {
            properties.put("ssl.keystore.password", this.ssl.getKeystorePassword());
        }
        if (this.ssl.getTruststoreLocation() != null) {
            properties.put("ssl.truststore.location", KafkaProperties.resourceToPath(this.ssl.getTruststoreLocation()));
        }
        if (this.ssl.getTruststorePassword() != null) {
            properties.put("ssl.truststore.password", this.ssl.getTruststorePassword());
        }
        if (!CollectionUtils.isEmpty(this.properties)) {
            properties.putAll(this.properties);
        }
        return properties;
    }

    public Map<String, Object> buildConsumerProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.consumer.buildProperties());
        return properties;
    }

    public Map<String, Object> buildProducerProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.producer.buildProperties());
        return properties;
    }

    public Map<String, Object> buildAdminProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.admin.buildProperties());
        return properties;
    }

    private static String resourceToPath(Resource resource) {
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Resource '" + resource + "' must be on a file system", ex);
        }
    }

    public static class Jaas {
        private boolean enabled;
        private String loginModule = "com.sun.security.auth.module.Krb5LoginModule";
        private KafkaJaasLoginModuleInitializer.ControlFlag controlFlag = KafkaJaasLoginModuleInitializer.ControlFlag.REQUIRED;
        private final Map<String, String> options = new HashMap<String, String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getLoginModule() {
            return this.loginModule;
        }

        public void setLoginModule(String loginModule) {
            this.loginModule = loginModule;
        }

        public KafkaJaasLoginModuleInitializer.ControlFlag getControlFlag() {
            return this.controlFlag;
        }

        public void setControlFlag(KafkaJaasLoginModuleInitializer.ControlFlag controlFlag) {
            this.controlFlag = controlFlag;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public void setOptions(Map<String, String> options) {
            if (options != null) {
                this.options.putAll(options);
            }
        }
    }

    public static class Ssl {
        private String keyPassword;
        private Resource keystoreLocation;
        private String keystorePassword;
        private Resource truststoreLocation;
        private String truststorePassword;

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public Resource getKeystoreLocation() {
            return this.keystoreLocation;
        }

        public void setKeystoreLocation(Resource keystoreLocation) {
            this.keystoreLocation = keystoreLocation;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public Resource getTruststoreLocation() {
            return this.truststoreLocation;
        }

        public void setTruststoreLocation(Resource truststoreLocation) {
            this.truststoreLocation = truststoreLocation;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }
    }

    public static class Listener {
        private Type type = Type.SINGLE;
        private AbstractMessageListenerContainer.AckMode ackMode;
        private Integer concurrency;
        private Duration pollTimeout;
        private Integer ackCount;
        private Duration ackTime;

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public AbstractMessageListenerContainer.AckMode getAckMode() {
            return this.ackMode;
        }

        public void setAckMode(AbstractMessageListenerContainer.AckMode ackMode) {
            this.ackMode = ackMode;
        }

        public Integer getConcurrency() {
            return this.concurrency;
        }

        public void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        public Duration getPollTimeout() {
            return this.pollTimeout;
        }

        public void setPollTimeout(Duration pollTimeout) {
            this.pollTimeout = pollTimeout;
        }

        public Integer getAckCount() {
            return this.ackCount;
        }

        public void setAckCount(Integer ackCount) {
            this.ackCount = ackCount;
        }

        public Duration getAckTime() {
            return this.ackTime;
        }

        public void setAckTime(Duration ackTime) {
            this.ackTime = ackTime;
        }

        public static enum Type {
            SINGLE,
            BATCH;

        }
    }

    public static class Template {
        private String defaultTopic;

        public String getDefaultTopic() {
            return this.defaultTopic;
        }

        public void setDefaultTopic(String defaultTopic) {
            this.defaultTopic = defaultTopic;
        }
    }

    public static class Admin {
        private final Ssl ssl = new Ssl();
        private String clientId;
        private final Map<String, String> properties = new HashMap<String, String>();
        private boolean failFast;

        public Ssl getSsl() {
            return this.ssl;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public boolean isFailFast() {
            return this.failFast;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (this.clientId != null) {
                properties.put("client.id", this.clientId);
            }
            if (this.ssl.getKeyPassword() != null) {
                properties.put("ssl.key.password", this.ssl.getKeyPassword());
            }
            if (this.ssl.getKeystoreLocation() != null) {
                properties.put("ssl.keystore.location", KafkaProperties.resourceToPath(this.ssl.getKeystoreLocation()));
            }
            if (this.ssl.getKeystorePassword() != null) {
                properties.put("ssl.keystore.password", this.ssl.getKeystorePassword());
            }
            if (this.ssl.getTruststoreLocation() != null) {
                properties.put("ssl.truststore.location", KafkaProperties.resourceToPath(this.ssl.getTruststoreLocation()));
            }
            if (this.ssl.getTruststorePassword() != null) {
                properties.put("ssl.truststore.password", this.ssl.getTruststorePassword());
            }
            properties.putAll(this.properties);
            return properties;
        }
    }

    public static class Producer {
        private final Ssl ssl = new Ssl();
        private String acks;
        private Integer batchSize;
        private List<String> bootstrapServers;
        private Long bufferMemory;
        private String clientId;
        private String compressionType;
        private Class<?> keySerializer = StringSerializer.class;
        private Class<?> valueSerializer = StringSerializer.class;
        private Integer retries;
        private String transactionIdPrefix;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Ssl getSsl() {
            return this.ssl;
        }

        public String getAcks() {
            return this.acks;
        }

        public void setAcks(String acks) {
            this.acks = acks;
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public Long getBufferMemory() {
            return this.bufferMemory;
        }

        public void setBufferMemory(Long bufferMemory) {
            this.bufferMemory = bufferMemory;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getCompressionType() {
            return this.compressionType;
        }

        public void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public Class<?> getKeySerializer() {
            return this.keySerializer;
        }

        public void setKeySerializer(Class<?> keySerializer) {
            this.keySerializer = keySerializer;
        }

        public Class<?> getValueSerializer() {
            return this.valueSerializer;
        }

        public void setValueSerializer(Class<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public String getTransactionIdPrefix() {
            return this.transactionIdPrefix;
        }

        public void setTransactionIdPrefix(String transactionIdPrefix) {
            this.transactionIdPrefix = transactionIdPrefix;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (this.acks != null) {
                properties.put("acks", this.acks);
            }
            if (this.batchSize != null) {
                properties.put("batch.size", this.batchSize);
            }
            if (this.bootstrapServers != null) {
                properties.put("bootstrap.servers", this.bootstrapServers);
            }
            if (this.bufferMemory != null) {
                properties.put("buffer.memory", this.bufferMemory);
            }
            if (this.clientId != null) {
                properties.put("client.id", this.clientId);
            }
            if (this.compressionType != null) {
                properties.put("compression.type", this.compressionType);
            }
            if (this.keySerializer != null) {
                properties.put("key.serializer", this.keySerializer);
            }
            if (this.retries != null) {
                properties.put("retries", this.retries);
            }
            if (this.ssl.getKeyPassword() != null) {
                properties.put("ssl.key.password", this.ssl.getKeyPassword());
            }
            if (this.ssl.getKeystoreLocation() != null) {
                properties.put("ssl.keystore.location", KafkaProperties.resourceToPath(this.ssl.getKeystoreLocation()));
            }
            if (this.ssl.getKeystorePassword() != null) {
                properties.put("ssl.keystore.password", this.ssl.getKeystorePassword());
            }
            if (this.ssl.getTruststoreLocation() != null) {
                properties.put("ssl.truststore.location", KafkaProperties.resourceToPath(this.ssl.getTruststoreLocation()));
            }
            if (this.ssl.getTruststorePassword() != null) {
                properties.put("ssl.truststore.password", this.ssl.getTruststorePassword());
            }
            if (this.valueSerializer != null) {
                properties.put("value.serializer", this.valueSerializer);
            }
            properties.putAll(this.properties);
            return properties;
        }
    }

    public static class Consumer {
        private final Ssl ssl = new Ssl();
        private Duration autoCommitInterval;
        private String autoOffsetReset;
        private List<String> bootstrapServers;
        private String clientId;
        private Boolean enableAutoCommit;
        private Duration fetchMaxWait;
        private Integer fetchMinSize;
        private String groupId;
        private Duration heartbeatInterval;
        private Class<?> keyDeserializer = StringDeserializer.class;
        private Class<?> valueDeserializer = StringDeserializer.class;
        private Integer maxPollRecords;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Ssl getSsl() {
            return this.ssl;
        }

        public Duration getAutoCommitInterval() {
            return this.autoCommitInterval;
        }

        public void setAutoCommitInterval(Duration autoCommitInterval) {
            this.autoCommitInterval = autoCommitInterval;
        }

        public String getAutoOffsetReset() {
            return this.autoOffsetReset;
        }

        public void setAutoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
        }

        public List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public Boolean getEnableAutoCommit() {
            return this.enableAutoCommit;
        }

        public void setEnableAutoCommit(Boolean enableAutoCommit) {
            this.enableAutoCommit = enableAutoCommit;
        }

        public Duration getFetchMaxWait() {
            return this.fetchMaxWait;
        }

        public void setFetchMaxWait(Duration fetchMaxWait) {
            this.fetchMaxWait = fetchMaxWait;
        }

        public Integer getFetchMinSize() {
            return this.fetchMinSize;
        }

        public void setFetchMinSize(Integer fetchMinSize) {
            this.fetchMinSize = fetchMinSize;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public Duration getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public void setHeartbeatInterval(Duration heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
        }

        public Class<?> getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public void setKeyDeserializer(Class<?> keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        public Class<?> getValueDeserializer() {
            return this.valueDeserializer;
        }

        public void setValueDeserializer(Class<?> valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
        }

        public Integer getMaxPollRecords() {
            return this.maxPollRecords;
        }

        public void setMaxPollRecords(Integer maxPollRecords) {
            this.maxPollRecords = maxPollRecords;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (this.autoCommitInterval != null) {
                properties.put("auto.commit.interval.ms", (int)this.autoCommitInterval.toMillis());
            }
            if (this.autoOffsetReset != null) {
                properties.put("auto.offset.reset", this.autoOffsetReset);
            }
            if (this.bootstrapServers != null) {
                properties.put("bootstrap.servers", this.bootstrapServers);
            }
            if (this.clientId != null) {
                properties.put("client.id", this.clientId);
            }
            if (this.enableAutoCommit != null) {
                properties.put("enable.auto.commit", this.enableAutoCommit);
            }
            if (this.fetchMaxWait != null) {
                properties.put("fetch.max.wait.ms", (int)this.fetchMaxWait.toMillis());
            }
            if (this.fetchMinSize != null) {
                properties.put("fetch.min.bytes", this.fetchMinSize);
            }
            if (this.groupId != null) {
                properties.put("group.id", this.groupId);
            }
            if (this.heartbeatInterval != null) {
                properties.put("heartbeat.interval.ms", (int)this.heartbeatInterval.toMillis());
            }
            if (this.keyDeserializer != null) {
                properties.put("key.deserializer", this.keyDeserializer);
            }
            if (this.ssl.getKeyPassword() != null) {
                properties.put("ssl.key.password", this.ssl.getKeyPassword());
            }
            if (this.ssl.getKeystoreLocation() != null) {
                properties.put("ssl.keystore.location", KafkaProperties.resourceToPath(this.ssl.getKeystoreLocation()));
            }
            if (this.ssl.getKeystorePassword() != null) {
                properties.put("ssl.keystore.password", this.ssl.getKeystorePassword());
            }
            if (this.ssl.getTruststoreLocation() != null) {
                properties.put("ssl.truststore.location", KafkaProperties.resourceToPath(this.ssl.getTruststoreLocation()));
            }
            if (this.ssl.getTruststorePassword() != null) {
                properties.put("ssl.truststore.password", this.ssl.getTruststorePassword());
            }
            if (this.valueDeserializer != null) {
                properties.put("value.deserializer", this.valueDeserializer);
            }
            if (this.maxPollRecords != null) {
                properties.put("max.poll.records", this.maxPollRecords);
            }
            properties.putAll(this.properties);
            return properties;
        }
    }
}

