/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.env.Environment;

public class MongoClientFactory {
    private final MongoProperties properties;
    private final Environment environment;

    public MongoClientFactory(MongoProperties properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
    }

    public MongoClient createMongoClient(MongoClientOptions options) {
        Integer embeddedPort = this.getEmbeddedPort();
        if (embeddedPort != null) {
            return this.createEmbeddedMongoClient(options, embeddedPort);
        }
        return this.createNetworkMongoClient(options);
    }

    private Integer getEmbeddedPort() {
        String localPort;
        if (this.environment != null && (localPort = this.environment.getProperty("local.mongo.port")) != null) {
            return Integer.valueOf(localPort);
        }
        return null;
    }

    private MongoClient createEmbeddedMongoClient(MongoClientOptions options, int port) {
        if (options == null) {
            options = MongoClientOptions.builder().build();
        }
        String host = this.properties.getHost() == null ? "localhost" : this.properties.getHost();
        return new MongoClient(Collections.singletonList(new ServerAddress(host, port)), Collections.emptyList(), options);
    }

    private MongoClient createNetworkMongoClient(MongoClientOptions options) {
        MongoProperties properties = this.properties;
        if (properties.getUri() != null) {
            return this.createMongoClient(properties.getUri(), options);
        }
        if (this.hasCustomAddress() || this.hasCustomCredentials()) {
            if (options == null) {
                options = MongoClientOptions.builder().build();
            }
            List<MongoCredential> credentials = this.getCredentials(properties);
            String host = this.getValue(properties.getHost(), "localhost");
            int port = this.getValue(properties.getPort(), 27017);
            List<ServerAddress> seeds = Collections.singletonList(new ServerAddress(host, port));
            return new MongoClient(seeds, credentials, options);
        }
        return this.createMongoClient("mongodb://localhost/test", options);
    }

    private MongoClient createMongoClient(String uri, MongoClientOptions options) {
        return new MongoClient(new MongoClientURI(uri, this.builder(options)));
    }

    private <T> T getValue(T value, T fallback) {
        return value == null ? fallback : value;
    }

    private boolean hasCustomAddress() {
        return this.properties.getHost() != null || this.properties.getPort() != null;
    }

    private List<MongoCredential> getCredentials(MongoProperties properties) {
        if (!this.hasCustomCredentials()) {
            return Collections.emptyList();
        }
        String username = properties.getUsername();
        String database = this.getValue(properties.getAuthenticationDatabase(), properties.getMongoClientDatabase());
        char[] password = properties.getPassword();
        return Collections.singletonList(MongoCredential.createCredential((String)username, (String)database, (char[])password));
    }

    private boolean hasCustomCredentials() {
        return this.properties.getUsername() != null && this.properties.getPassword() != null;
    }

    private MongoClientOptions.Builder builder(MongoClientOptions options) {
        if (options != null) {
            return MongoClientOptions.builder((MongoClientOptions)options);
        }
        return MongoClientOptions.builder();
    }
}

