/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.undertow.UndertowOptions;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class UndertowWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableUndertowWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public UndertowWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableUndertowWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        ServerProperties.Undertow undertowProperties = properties.getUndertow();
        ServerProperties.Undertow.Accesslog accesslogProperties = undertowProperties.getAccesslog();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(undertowProperties::getBufferSize).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setBufferSize(arg_0));
        propertyMapper.from(undertowProperties::getIoThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setIoThreads(arg_0));
        propertyMapper.from(undertowProperties::getWorkerThreads).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setWorkerThreads(arg_0));
        propertyMapper.from(undertowProperties::getDirectBuffers).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseDirectBuffers(arg_0));
        propertyMapper.from(accesslogProperties::getEnabled).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogEnabled(arg_0));
        propertyMapper.from(accesslogProperties::getDir).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogDirectory(arg_0));
        propertyMapper.from(accesslogProperties::getPattern).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPattern(arg_0));
        propertyMapper.from(accesslogProperties::getPrefix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogPrefix(arg_0));
        propertyMapper.from(accesslogProperties::getSuffix).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogSuffix(arg_0));
        propertyMapper.from(accesslogProperties::isRotate).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setAccessLogRotate(arg_0));
        propertyMapper.from(() -> this.getOrDeduceUseForwardHeaders()).to(arg_0 -> ((ConfigurableUndertowWebServerFactory)factory).setUseForwardHeaders(arg_0));
        propertyMapper.from(properties::getMaxHttpHeaderSize).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(undertowProperties::getMaxHttpPostSize).when(this::isPositive).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(factory, (long)maxHttpPostSize));
        propertyMapper.from(properties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> deploymentInfo.setEagerFilterInit(undertowProperties.isEagerFilterInit())});
    }

    private boolean isPositive(Number value) {
        return value.longValue() > 0L;
    }

    private void customizeConnectionTimeout(ConfigurableUndertowWebServerFactory factory, Duration connectionTimeout) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setSocketOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)((int)connectionTimeout.toMillis()))});
    }

    private void customizeMaxHttpHeaderSize(ConfigurableUndertowWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)maxHttpHeaderSize)});
    }

    private void customizeMaxHttpPostSize(ConfigurableUndertowWebServerFactory factory, long maxHttpPostSize) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)maxHttpPostSize)});
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.isUseForwardHeaders() != null) {
            return this.serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
        return platform != null && platform.isUsingForwardHeaders();
    }
}

