/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo.embedded;

import de.flapdoodle.embed.mongo.distribution.Feature;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(prefix="spring.mongodb.embedded")
public class EmbeddedMongoProperties {
    private String version = "3.2.2";
    private final Storage storage = new Storage();
    private Set<Feature> features = new HashSet<Feature>(Collections.singletonList(Feature.SYNC_DELAY));

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Set<Feature> features) {
        this.features = features;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public static class Storage {
        @DataSizeUnit(value=DataUnit.MEGABYTES)
        private DataSize oplogSize;
        private String replSetName;
        private String databaseDir;

        public DataSize getOplogSize() {
            return this.oplogSize;
        }

        public void setOplogSize(DataSize oplogSize) {
            this.oplogSize = oplogSize;
        }

        public String getReplSetName() {
            return this.replSetName;
        }

        public void setReplSetName(String replSetName) {
            this.replSetName = replSetName;
        }

        public String getDatabaseDir() {
            return this.databaseDir;
        }

        public void setDatabaseDir(String databaseDir) {
            this.databaseDir = databaseDir;
        }
    }
}

