/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ClientsConfiguredCondition
extends SpringBootCondition {
    private static final Bindable<Map<String, OAuth2ClientProperties.LoginClientRegistration>> STRING_LOGIN_REGISTRATION_MAP = Bindable.mapOf(String.class, OAuth2ClientProperties.LoginClientRegistration.class);
    private static final Bindable<Map<String, OAuth2ClientProperties.AuthorizationCodeClientRegistration>> STRING_AUTHORIZATION_CODE_REGISTRATION_MAP = Bindable.mapOf(String.class, OAuth2ClientProperties.AuthorizationCodeClientRegistration.class);

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition("OAuth2 Clients Configured Condition", new Object[0]);
        Map<String, OAuth2ClientProperties.BaseClientRegistration> registrations = this.getRegistrations(context.getEnvironment());
        if (!registrations.isEmpty()) {
            return ConditionOutcome.match(message.foundExactly("registered clients " + registrations.values().stream().map(OAuth2ClientProperties.BaseClientRegistration::getClientId).collect(Collectors.joining(", "))));
        }
        return ConditionOutcome.noMatch(message.notAvailable("registered clients"));
    }

    private Map<String, OAuth2ClientProperties.BaseClientRegistration> getRegistrations(Environment environment) {
        HashMap<String, OAuth2ClientProperties.BaseClientRegistration> registrations = new HashMap<String, OAuth2ClientProperties.BaseClientRegistration>();
        Map loginClientRegistrations = (Map)Binder.get((Environment)environment).bind("spring.security.oauth2.client.registration.login", STRING_LOGIN_REGISTRATION_MAP).orElse(Collections.emptyMap());
        Map authCodeClientRegistrations = (Map)Binder.get((Environment)environment).bind("spring.security.oauth2.client.registration.authorizationcode", STRING_AUTHORIZATION_CODE_REGISTRATION_MAP).orElse(Collections.emptyMap());
        registrations.putAll(loginClientRegistrations);
        registrations.putAll(authCodeClientRegistrations);
        return registrations;
    }
}

