/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.servlet;

import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.KeyValueCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

@Configuration(proxyBeanMethods=false)
class OAuth2ResourceServerJwtConfiguration {
    private final OAuth2ResourceServerProperties.Jwt properties;

    OAuth2ResourceServerJwtConfiguration(OAuth2ResourceServerProperties properties) {
        this.properties = properties.getJwt();
    }

    @Bean
    @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
    @ConditionalOnMissingBean
    public JwtDecoder jwtDecoderByJwkKeySetUri() {
        return NimbusJwtDecoder.withJwkSetUri((String)this.properties.getJwkSetUri()).jwsAlgorithm((JwsAlgorithm)SignatureAlgorithm.from((String)this.properties.getJwsAlgorithm())).build();
    }

    @Bean
    @Conditional(value={KeyValueCondition.class})
    @ConditionalOnMissingBean
    public JwtDecoder jwtDecoderByPublicKeyValue() throws Exception {
        RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.getKeySpec(this.properties.readPublicKey())));
        return NimbusJwtDecoder.withPublicKey((RSAPublicKey)publicKey).build();
    }

    private byte[] getKeySpec(String keyValue) {
        keyValue = keyValue.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\n", "");
        return Base64.getDecoder().decode(keyValue);
    }

    @Bean
    @Conditional(value={IssuerUriCondition.class})
    @ConditionalOnMissingBean
    public JwtDecoder jwtDecoderByIssuerUri() {
        return JwtDecoders.fromOidcIssuerLocation((String)this.properties.getIssuerUri());
    }
}

