/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.reactive;

import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.KeyValueCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoders;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration(proxyBeanMethods=false)
class ReactiveOAuth2ResourceServerJwkConfiguration {
    ReactiveOAuth2ResourceServerJwkConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={SecurityWebFilterChain.class})
    static class WebSecurityConfiguration {
        WebSecurityConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ReactiveJwtDecoder.class})
        public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, ReactiveJwtDecoder jwtDecoder) {
            http.authorizeExchange().anyExchange().authenticated().and().oauth2ResourceServer().jwt().jwtDecoder(jwtDecoder);
            return http.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ReactiveJwtDecoder.class})
    static class JwtConfiguration {
        private final OAuth2ResourceServerProperties.Jwt properties;

        JwtConfiguration(OAuth2ResourceServerProperties properties) {
            this.properties = properties.getJwt();
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
        public ReactiveJwtDecoder jwtDecoder() {
            return new NimbusReactiveJwtDecoder(this.properties.getJwkSetUri());
        }

        @Bean
        @Conditional(value={KeyValueCondition.class})
        public NimbusReactiveJwtDecoder jwtDecoderByPublicKeyValue() throws Exception {
            RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.getKeySpec(this.properties.readPublicKey())));
            return NimbusReactiveJwtDecoder.withPublicKey((RSAPublicKey)publicKey).build();
        }

        private byte[] getKeySpec(String keyValue) {
            keyValue = keyValue.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
            return Base64.getMimeDecoder().decode(keyValue);
        }

        @Bean
        @Conditional(value={IssuerUriCondition.class})
        public ReactiveJwtDecoder jwtDecoderByIssuerUri() {
            return ReactiveJwtDecoders.fromOidcIssuerLocation((String)this.properties.getIssuerUri());
        }
    }
}

