/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.reactive;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.server.resource.introspection.NimbusReactiveOAuth2TokenIntrospectionClient;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOAuth2TokenIntrospectionClient;
import org.springframework.security.web.server.SecurityWebFilterChain;

class ReactiveOAuth2ResourceServerOpaqueTokenConfiguration {
    ReactiveOAuth2ResourceServerOpaqueTokenConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={SecurityWebFilterChain.class})
    static class WebSecurityConfiguration {
        WebSecurityConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ReactiveOAuth2TokenIntrospectionClient.class})
        public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
            http.authorizeExchange().anyExchange().authenticated().and().oauth2ResourceServer().opaqueToken();
            return http.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ReactiveOAuth2TokenIntrospectionClient.class})
    static class OpaqueTokenIntrospectionClientConfiguration {
        OpaqueTokenIntrospectionClientConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.opaque-token.introspection-uri"})
        public NimbusReactiveOAuth2TokenIntrospectionClient oAuth2TokenIntrospectionClient(OAuth2ResourceServerProperties properties) {
            OAuth2ResourceServerProperties.OpaqueToken opaqueToken = properties.getOpaqueToken();
            return new NimbusReactiveOAuth2TokenIntrospectionClient(opaqueToken.getIntrospectionUri(), opaqueToken.getClientId(), opaqueToken.getClientSecret());
        }
    }
}

