/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.docker.type.LayerId;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.InspectedContent;
import org.springframework.boot.buildpack.platform.io.Layout;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;

public class ImageArchive
implements TarArchive {
    private static final Instant WINDOWS_EPOCH_PLUS_SECOND = OffsetDateTime.of(1980, 1, 1, 0, 0, 1, 0, ZoneOffset.UTC).toInstant();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(ZoneOffset.UTC);
    private static final IOConsumer<Update> NO_UPDATES = update -> {};
    private final ObjectMapper objectMapper;
    private final ImageConfig imageConfig;
    private final Instant createDate;
    private final ImageReference tag;
    private final String os;
    private final List<LayerId> existingLayers;
    private final List<Layer> newLayers;

    ImageArchive(ObjectMapper objectMapper, ImageConfig imageConfig, Instant createDate, ImageReference tag, String os, List<LayerId> existingLayers, List<Layer> newLayers) {
        this.objectMapper = objectMapper;
        this.imageConfig = imageConfig;
        this.createDate = createDate;
        this.tag = tag;
        this.os = os;
        this.existingLayers = existingLayers;
        this.newLayers = newLayers;
    }

    public ImageConfig getImageConfig() {
        return this.imageConfig;
    }

    public Instant getCreateDate() {
        return this.createDate;
    }

    public ImageReference getTag() {
        return this.tag;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        TarArchive.of(this::write).writeTo(outputStream);
    }

    private void write(Layout writer) throws IOException {
        List<LayerId> writtenLayers = this.writeLayers(writer);
        String config = this.writeConfig(writer, writtenLayers);
        this.writeManifest(writer, config, writtenLayers);
    }

    private List<LayerId> writeLayers(Layout writer) throws IOException {
        ArrayList<LayerId> writtenLayers = new ArrayList<LayerId>();
        for (Layer layer : this.newLayers) {
            writtenLayers.add(this.writeLayer(writer, layer));
        }
        return Collections.unmodifiableList(writtenLayers);
    }

    private LayerId writeLayer(Layout writer, Layer layer) throws IOException {
        LayerId id = layer.getId();
        writer.file("/" + id.getHash() + ".tar", Owner.ROOT, layer);
        return id;
    }

    private String writeConfig(Layout writer, List<LayerId> writtenLayers) throws IOException {
        try {
            ObjectNode config = this.createConfig(writtenLayers);
            String json = this.objectMapper.writeValueAsString((Object)config).replace("\r\n", "\n");
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            InspectedContent.Inspector[] inspectorArray = new InspectedContent.Inspector[1];
            inspectorArray[0] = digest::update;
            InspectedContent content = InspectedContent.of(Content.of(json), inspectorArray);
            String name = "/" + LayerId.ofSha256Digest(digest.digest()).getHash() + ".json";
            writer.file(name, Owner.ROOT, content);
            return name;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private ObjectNode createConfig(List<LayerId> writtenLayers) {
        ObjectNode config = this.objectMapper.createObjectNode();
        config.set("config", this.imageConfig.getNodeCopy());
        config.set("created", (JsonNode)config.textNode(this.getCreatedDate()));
        config.set("history", this.createHistory(writtenLayers));
        config.set("os", (JsonNode)config.textNode(this.os));
        config.set("rootfs", this.createRootFs(writtenLayers));
        return config;
    }

    private String getCreatedDate() {
        return DATE_FORMATTER.format(this.createDate);
    }

    private JsonNode createHistory(List<LayerId> writtenLayers) {
        ArrayNode history = this.objectMapper.createArrayNode();
        int size = this.existingLayers.size() + writtenLayers.size();
        for (int i = 0; i < size; ++i) {
            history.addObject();
        }
        return history;
    }

    private JsonNode createRootFs(List<LayerId> writtenLayers) {
        ObjectNode rootFs = this.objectMapper.createObjectNode();
        ArrayNode diffIds = rootFs.putArray("diff_ids");
        this.existingLayers.stream().map(Object::toString).forEach(arg_0 -> ((ArrayNode)diffIds).add(arg_0));
        writtenLayers.stream().map(Object::toString).forEach(arg_0 -> ((ArrayNode)diffIds).add(arg_0));
        return rootFs;
    }

    private void writeManifest(Layout writer, String config, List<LayerId> writtenLayers) throws IOException {
        ArrayNode manifest = this.createManifest(config, writtenLayers);
        String manifestJson = this.objectMapper.writeValueAsString((Object)manifest);
        writer.file("/manifest.json", Owner.ROOT, Content.of(manifestJson));
    }

    private ArrayNode createManifest(String config, List<LayerId> writtenLayers) {
        ArrayNode manifest = this.objectMapper.createArrayNode();
        ObjectNode entry = manifest.addObject();
        entry.set("Config", (JsonNode)entry.textNode(config));
        entry.set("Layers", (JsonNode)this.getManifestLayers(writtenLayers));
        if (this.tag != null) {
            entry.set("RepoTags", (JsonNode)entry.arrayNode().add(this.tag.toString()));
        }
        return manifest;
    }

    private ArrayNode getManifestLayers(List<LayerId> writtenLayers) {
        ArrayNode layers = this.objectMapper.createArrayNode();
        for (int i = 0; i < this.existingLayers.size(); ++i) {
            layers.add("");
        }
        writtenLayers.stream().map(id -> id.getHash() + ".tar").forEach(arg_0 -> ((ArrayNode)layers).add(arg_0));
        return layers;
    }

    public static ImageArchive from(Image image) throws IOException {
        return ImageArchive.from(image, NO_UPDATES);
    }

    public static ImageArchive from(Image image, IOConsumer<Update> update) throws IOException {
        return new Update(image).applyTo(update);
    }

    public static final class Update {
        private final Image image;
        private ImageConfig config;
        private Instant createDate;
        private ImageReference tag;
        private final List<Layer> newLayers = new ArrayList<Layer>();

        private Update(Image image) {
            this.image = image;
            this.config = image.getConfig();
        }

        private ImageArchive applyTo(IOConsumer<Update> update) throws IOException {
            update.accept(this);
            Instant createDate = this.createDate != null ? this.createDate : WINDOWS_EPOCH_PLUS_SECOND;
            return new ImageArchive(SharedObjectMapper.get(), this.config, createDate, this.tag, this.image.getOs(), this.image.getLayers(), Collections.unmodifiableList(this.newLayers));
        }

        public void withUpdatedConfig(Consumer<ImageConfig.Update> update) {
            this.config = this.config.copy(update);
        }

        public void withNewLayer(Layer layer) {
            Assert.notNull((Object)layer, (String)"Layer must not be null");
            this.newLayers.add(layer);
        }

        public void withCreateDate(Instant createDate) {
            Assert.notNull((Object)createDate, (String)"CreateDate must not be null");
            this.createDate = createDate;
        }

        public void withTag(ImageReference tag) {
            Assert.notNull((Object)tag, (String)"Tag must not be null");
            this.tag = tag.inTaggedForm();
        }
    }
}

