/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.Objects;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Cache {
    protected final Format format;

    Cache(Format format) {
        this.format = format;
    }

    public Volume getVolume() {
        return this.format.equals((Object)Format.VOLUME) ? (Volume)this : null;
    }

    public Bind getBind() {
        return this.format.equals((Object)Format.BIND) ? (Bind)this : null;
    }

    public static Cache volume(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Volume(VolumeName.of(name));
    }

    public static Cache volume(VolumeName name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Volume(name);
    }

    public static Cache bind(String source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        return new Bind(source);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cache other = (Cache)obj;
        return Objects.equals((Object)this.format, (Object)other.format);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)((Object)this.format));
    }

    public static enum Format {
        VOLUME("volume"),
        BIND("bind mount");

        private final String description;

        private Format(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Volume
    extends Cache {
        private final VolumeName name;

        Volume(VolumeName name) {
            super(Format.VOLUME);
            this.name = name;
        }

        public String getName() {
            return this.name.toString();
        }

        public VolumeName getVolumeName() {
            return this.name;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Volume other = (Volume)obj;
            return Objects.equals(this.name, other.name);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
            return result;
        }

        public String toString() {
            return this.format.getDescription() + " '" + String.valueOf(this.name) + "'";
        }
    }

    public static class Bind
    extends Cache {
        private final String source;

        Bind(String source) {
            super(Format.BIND);
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Bind other = (Bind)obj;
            return Objects.equals(this.source, other.source);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.source);
            return result;
        }

        public String toString() {
            return this.format.getDescription() + " '" + this.source + "'";
        }
    }
}

