/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.buildpack.platform.docker.transport;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jspecify.annotations.Nullable;

/**
 * A message returned from the Docker API.
 *
 * @author Scott Frederick
 * @since 2.3.1
 */
public class Message {

	private final @Nullable String message;

	@JsonCreator
	Message(@JsonProperty("message") @Nullable String message) {
		this.message = message;
	}

	/**
	 * Return the message contained in the response.
	 * @return the message
	 */
	public @Nullable String getMessage() {
		return this.message;
	}

	@Override
	public String toString() {
		return (this.message == null) ? "<null>" : this.message;
	}

}
